;Chris Covell's Wide Boy replacement ROM!
;This code runs entirely in the FC's (tight) RAM.
	ZP
Spr_RAM		ds 16	;Storage for 4 sprites
;PPU2005V	ds 1
;PPU2005H	ds 1
PPU2001		ds 1
PPU2000		ds 1

CONT1		ds 1                  ;0-> A,B,SL,ST,U,D,L,R <-7
CONT1LAST	ds 1		;Reading of the last controller
CONT1STROBE	ds 1
TEMPBYT1	ds 1
TEMPBYT2	ds 1
TEMPBYT3	ds 1
TEMPBYT4	ds 1
;---------------------
PALNUM1		ds 1   	;Pointers for each of the BG pals
PALNUM2		ds 1
PALNUM3		ds 1
PALNUM4		ds 1
MODE		ds 1	;Mode the program is in...
			;0 = normal, A/B cycles pals.
			;1 = Pal Selection
			;2 = Pal Editing
			;3 = ATT (GB Screen) Editing
CURSY           ds 1	;Cursor position on-screen (for ATT)
CURSX           ds 1
EDITPAL        ds 1	;Selects which palette bank & colour (0..F) to adjust
BDROP_NUM	ds 1	;The "backdrop" number. 0 = Col 0...,4 = GameBoy,
BDROP_MAX	EQU 4	;Current maximum for backdrop...
;--
PPUADDR		ds 2	;Pointer for a PPU writing function
VBROUTINE	ds 1	;Enumerated list for routines triggered in VBlank
;VBADDR		ds 2	;Storage of address for above routine
VBPARA		ds 1	;Parameter storage (if needed) for the A register
;VBPARX		ds 1	;... X register
;VBPARY		ds 1	;... y register

        CODE
	LIST
;=============================
        .org $0110
RAM_Code_Start:                 ;Start of code; init global variables here!
	lda	#$04
	sta	<BDROP_NUM	;Start on which backdrop

	ldy	#$00
;	sty	$2000                ;NO NMI,Sprite CHR
;	sty	$2001
	sty	<MODE           ;Put into "BASIC" mode...
	sty	<VBROUTINE      ;No routines to process

	sty	<PALNUM1	;Init the palette pointers
	iny
	sty	<PALNUM2
;	iny
;	sty	<PALNUM3

	lda	#$23
	sta	$2006
	lda	#$C0
	sta	$2006		;Point to ATT table
;	ldy	#$00		;$64 times, hopefully...
	ldx	#$40
  	lda	#$FF
	jsr     Fill_Byte   	;ATT fill ***
;------------

restart_pos:          		;Restart position (don't clear variables...)

	lda	#%00000000		;NO NMI,Sprite CHR
	sta	$2000
	sta	<PPU2000
	sta	$2001
	sta	<PPU2001

	jsr	Setup_PPU

	lda	#$00
	sta	$2005
;	sta	<PPU2005H
	sta	$2005
;	sta	<PPU2005V
;	lda	#%00000000		;NMI,Sprite CHR
	sta	$2000
	sta	<PPU2000
	lda	#%00011110		;Sprites on(!),Screen on, no clipping.
	sta	$2001
	sta	<PPU2001


;@@@@@@@@@@@@@@ MAIN LOOP @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
waitvbA:	lda	$2002		;Wait for VBlank to end
	bmi	waitvbA
waitvbB:	lda	$2002		;Wait for VBlank to start again
	bpl	waitvbB
;---------------------------- This waits 1 VBlank, right? ----------------
	jsr	Sprite_Write
	jsr	Check_VB_Routine	;Executes a pending routine
	lda	<PPU2000
	sta	$2000		;Change PPU settings
;	lda	<PPU2005H	;Update scrolling, at least
	lda	#$00
	sta	$2005
;	lda	<PPU2005V
	sta	$2005
	jsr	Check_Controller
	jmp	waitvbA                ;Go back to main loop!
;@@@@@@@@@@@@@@ MAIN LOOP @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@





;============ SUBROUTINES!! ============
Check_VB_Routine:           ;Jumps to routines during VBlank
	lda	<VBROUTINE	;Is anything pending?
	beq	.nothing_waiting
	asl	a	;Address-wide
	tax
	lda     Rtn_List-2,X	;Shifts to entry 0
	sta     <PPUADDR
	lda     Rtn_List-1,X	;Get routine from list...
	sta     <PPUADDR+1       ;Save to jump addr.
	lda	#$00
	sta	<VBROUTINE	;NO more routines!
	lda	<VBPARA         ;Get A,X,Y parameters
;	ldx	<VBPARX
;	ldy	<VBPARY
	jmp	[PPUADDR]	;Jump away!
.nothing_waiting:
	rts
SETPAL = 1                             ;What numeric value is each routine?
TOBASIC = 2
TOPALEDIT = 3
SETATT = 4
Rtn_List: DW SetPal,Go_To_Basic_Mode,Go_To_Pal_Edit,Set_Attribute
;A list of routines to jump to
;=============================================================================

Check_Controller:
	jsr	Strobe_Cont	;Does the technical stuff.

	lda	<CONT1STROBE
	and	#$01
	beq	.NotRPressed
;RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR
	lda	<MODE
	cmp	#$01
	beq	.next_pal_bank
	cmp	#$02
	beq	.next_palette
;--------------- Now we're at mode 3 (or 0...)
	inc	<CURSX
	lda	<CURSX
	cmp	#$0A	;Is it at the end of the screen?
	bne	.no_resetx
	lda	#$00
.no_resetx:
	sta	<CURSX
 	jmp	Posn_Sprites		;Why not?

.next_pal_bank:
	lda	<EDITPAL       ;Move to the next pal bank
	clc
	adc	#$04            ;4 palettes each
	bne	.L01		;(This will always be non-zero)
	
.next_palette:
	inc	<EDITPAL        ;Go to next palette
	lda	<EDITPAL
	bne	.L01		;(This will always be non-zero)
;LLLLLLLLLLLLLLLLLLLLLLLLLLLLLL
.NotRPressed
	lda	<CONT1STROBE
	and	#$02
	beq	.NotLPressed

 	lda	<MODE
	cmp	#$01
	beq	.prev_pal_bank
	cmp	#$02
	beq	.prev_palette

;--------------- Now we're at mode 3 (or 0...)
	dec	<CURSX
	lda	<CURSX
	cmp	#$FF	;Is it at the end of the screen?
	bne	.no_resetx2
	lda	#$09
.no_resetx2:
	bpl     .no_resetx

.prev_palette:
	dec	<EDITPAL        ;Go to next palette
	lda	<EDITPAL
	jmp	.L01

.prev_pal_bank:
	lda	<EDITPAL       ;Move to the next pal bank
	sec
	sbc	#$04            ;4 palettes each
.L01:	and	#$0F            ;Limit to 0-16
	sta	<EDITPAL
	jmp	Posn_Sprites	;Why not?
;DDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
.NotLPressed
	lda	<CONT1STROBE
	and	#$04
	beq	.NotDPressed

 	lda	<MODE
	cmp	#$01
	beq	.up_pal_bank
	cmp	#$02
	beq	.up_palette
;--------------- Now we're at mode 3 (or 0...)
	inc	<CURSY
	lda	<CURSY
	cmp	#$09	;Is it at the end of the screen?
	bne	.no_resety
	lda	#$00
.no_resety:
	sta	<CURSY
 	jmp	Posn_Sprites		;Why not?

;UUUUUUUUUUUUUUUUUUUUUUUUUUUUU
.NotDPressed
        lda	<CONT1STROBE
	and	#$08
	beq	.NotUPressed

 	lda	<MODE
	cmp	#$01
	beq	.up_pal_bank
	cmp	#$02
	beq	.up_palette
;--------------- Now we're at mode 3 (or 0...)
	dec	<CURSY
	lda	<CURSY
	cmp	#$FF	;Is it at the end of the screen?
	bne	.no_resety2
	lda	#$08
.no_resety2:
	bpl	.no_resety

.up_pal_bank:
	jmp	Select_Palettes        		;The subroutine will RTS...?
.up_palette:
	jmp	Change_Palette_Entry            ;The subroutine will RTS...?
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
.NotUPressed
	lda	<CONT1STROBE
	and	#$80
	beq	.NotAPressed
	lda	<MODE
	bne	.A_notmode0
	inc	<PALNUM1
	lda	<PALNUM1
	cmp     #BORDPAL        ;is it past its pal limits?
	bmi	.no_reset_pal
	lda	#$00
	sta	<PALNUM1
.no_reset_pal:
	lda	#$00
	sta     <VBPARA		;Give it a parameter
	lda	#SETPAL		;Change pal 0
	sta	<VBROUTINE
	rts			;Get out!
.A_notmode0:
	cmp	#$01       	;Was the mode 1?
	bne     .A_notmode1
	inc	<MODE           ;Go to mode 2 (pal editing)
	bne     .b_sprite	;Exit!
.A_notmode1:
	cmp	#$03
	bne	.NotAPressed
	lda	#SETATT
	sta	<VBROUTINE
	rts
;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
.NotAPressed
	lda	<CONT1STROBE
	and	#$40
	beq	.NotBPressed
	lda	<MODE
	bne	.B_notmode0
	dec	<PALNUM1         ;Decrement the Palette
	bpl	.no_reset_palB
	lda	#BORDPAL-1
	sta	<PALNUM1
.no_reset_palB:
	lda	#$00
	sta     <VBPARA		;Give it a parameter
	lda	#SETPAL		;Change pal 0
	sta	<VBROUTINE
	rts
.B_notmode0:
	cmp	#$03
	beq	.toggle_mode1_3
	cmp	#$01       	;Was the mode 1?
	bne     .B_notmode1
	;If so... go to ATT Editing Mode (3)
.toggle_mode1_3:
	eor	#$02		;01<->03
	sta	<MODE
        bne	.b_sprite
.B_notmode1:
;	cmp	#$02       	;Was the mode 2?     Check not needed...
;	bne     .B_notmode2
	;If it was mode 2, go down to mode 1
	dec	<MODE
	lda     <EDITPAL
	and	#$0C		;Limit to pal banks
	sta	<EDITPAL
.b_sprite:
	jmp	Posn_Sprites	;Why not?
;.B_notmode2:

;SELECT SELECT SELECT SELECT SELECT SELECT SELECT SELECT SELECT
.NotBPressed:
	lda	<CONT1STROBE
	and	#$20
	beq	.NotSELPressed
	lda	<MODE
	beq	.turnon_paledit		;Go from basic mode -> Pal edit mode
	lda	#TOBASIC        ;Call the routine next Vblank.
	bne	.wrt_vbpar	;Always branch...
.turnon_paledit:
	lda	#TOPALEDIT        ;Call the routine position next Vblank.
.wrt_vbpar:
	sta     <VBROUTINE
;START START START START START START START START START
.NotSELPressed
        lda	<CONT1STROBE
	and	#$10
	beq	.NotSTAPressed
	dec	<BDROP_NUM
;	lda     <BDROP_NUM
;	cmp	#$FF
;	bne	
	bpl	.no_rst_bdrop
	lda	#BDROP_MAX
	sta	<BDROP_NUM
.no_rst_bdrop:
	pla	; Get rid of return address.......
	pla
	jmp	restart_pos		;Reset our program!!
.NotSTAPressed

	rts
	
	
	
	
	
	
;============================================================================
;============================================================================
Select_Palettes:
	lda	<EDITPAL		;get palette to edit
	lsr	a
	lsr	a			;Move to index
	tax
	stx	<VBPARA			;Save as palette parameter
	ldy	<PALNUM1,X              ;get palette ptr
	lda     <CONT1STROBE
	and	#$08                    ;If "UP", decrease
	bne	.dec_pal
;------------------------ so now we increase the pal ptr
	iny
	cpy	#BORDPAL+1		;Is it past all the palettes?
	bne	.no_rset_pal_ptr
	ldy	#$00
.no_rset_pal_ptr:
	jmp	.write_pal_bank
;---------------------
.dec_pal:
	dey
	bpl	.no_set_pal_ptr		;branches if not $FF?...
	ldy     #BORDPAL		;Load from end of border palette(s).
.no_set_pal_ptr:
.write_pal_bank:
	sty	<PALNUM1,X
	lda     #SETPAL
	sta	<VBROUTINE
	rts

Change_Palette_Entry:
	lda	<EDITPAL		;get palette to edit
	lsr	a
	lsr	a			;Move to index
	tax
	stx	<VBPARA			;Save as palette parameter
	lda	<PALNUM1,X		;get palette ptr
	asl	a
	asl	a			;Mult by 4 to skip entries
	sta	<TEMPBYT1
	lda	<EDITPAL
	and	#$03			;isolate pal 0..3
	ora	<TEMPBYT1
	tax
	ldy     Palettes,X		;Get palette entry from list...
	lda	<CONT1STROBE
        and	#$08                    ;If "UP", add $10 to pal
	bne	.add_16_pal
	;---------
	iny                             ;otherwise, inc pal by 1
	tya
	and	#$0F			;check if $X0
	bne	.no_decrease_pal
	tya
	sec
	sbc	#$10
	tay
.no_decrease_pal:
	tya
	jmp	.write_pal_num
.add_16_pal:
	tya				;simply add $10 to pal
	clc
	adc	#$10
.write_pal_num:
	sta	Palettes,X
	lda     #SETPAL
	sta	<VBROUTINE
	rts



Set_Attribute:		;Sets the attributes for the GB screen
	lda	<CURSY
	clc
	adc	#$03		;Change Y-offset!
	asl	a
	sta	<TEMPBYT1	;Store
	asl	a               ;Move to $00..$38
	and	#$38		;Reduce range
	sta	<TEMPBYT3

	lda	<CURSX
	clc
	adc	#$03		;Change X-offset!
	sta	<TEMPBYT2	;Store
	lsr	a               ;Limit to $00..$07
	ora     <TEMPBYT3
	clc
	adc	#$C0		;Point to $23C0
	sta	<TEMPBYT3	;Save it
	ldy	#$23
	sty	$2006
	sta	$2006
	ldx	$2007		;This is a dummy (?)
	ldx	$2007		;This is the real one

	lda     <TEMPBYT2       ;Get X bit 1 only
	and	#$01
	sta     <TEMPBYT2
	lda	<TEMPBYT1       ;Get Y bit 1 only
	and	#$02
	ora	<TEMPBYT2	;Get the offset into the byte... 000000YX
	asl	a		;00000YX0
	tay
	lda     <EDITPAL        ;Get palette bank
	lsr	a
	lsr	a
	sta	<TEMPBYT1	;Save it for shifting
	lda	#%11111100      ;Get a bitmask
	sta	<TEMPBYT2	;Save it too
.start_shift:
	cpy	#$00
	beq	.exit_shift
	asl     <TEMPBYT1	;Shift over our byte: 00000BB0
	sec
	rol     <TEMPBYT2	;Shift the mask: 11111001 etc
	dey
	bne     .start_shift
 .exit_shift:
        txa                     ;Get our ATT byte read from $2007
        and	<TEMPBYT2	;Mask it
        ora     <TEMPBYT1	;Add our pal #
 
	ldy	#$23
	sty	$2006
	ldy     <TEMPBYT3	;get our writing add
	sty	$2006
	sta	$2007		;Write it back...
	rts
;============================================================================






Go_To_Basic_Mode          ;Turns off palette-editing mode
	lda	#$00
	sta	<MODE			;Mode is now palette editing
 ;	lda	#$00
	sta	$2001	;Screen OFF!
	jsr	Draw_Backdrop
	jsr	FillGBTiles	;Fills in the GB screen itself
	lda	#$23
	sta	$2006
	lda	#$F0
	sta	$2006	;Point near the bottom of the ATT TBL...

	lda	#$FF    ;Reset it...
	ldx	#$06
.drbaslp:
	sta	$2007
	dex
	bne	.drbaslp

	jsr	Posn_Sprites     ;Clear sprites, really...

	lda	<PPU2001
	sta	$2001	;Turn screen back on
	rts
;--------------------------------------------------------
Go_To_Pal_Edit            ;Turns on palette-editing mode

	ldx	#$00
	stx	$2001	;Screen OFF!
	inx
	stx	<MODE			;Mode is now palette editing
	jsr	Draw_Edit_Scr
	lda	#$00
	sta	<CURSY   	;Clear our cursor positions...
	sta	<CURSX
	sta	<EDITPAL
	jsr	Posn_Sprites
.topaledit_end:
	lda	<PPU2001
	sta	$2001	;Turn screen back on
	rts
;============================================================================
Draw_Edit_Scr:
	lda	#$00
	sta	$2001	;Screen OFF!

	lda	#$23
	sta	$2006
	lda	#$40
	sta	$2006	;Point near the bottom of the screen...
	
	ldx	#$08
.draw_gradient0:
	ldy	#$FC
.draw_gradient1:
	sty	$2007
	sty	$2007
	iny
	bne	.draw_gradient1
	dex
	bne     .draw_gradient0
	
	lda	#$23
	sta	$2006
	lda	#$F0
	sta	$2006	;Point near the bottom of the ATT TBL...
	
	lda	#$0F
	sta	$2007
	sta	$2007
	lda	#$5F
	sta	$2007
	sta	$2007
	lda	#$AF
	sta	$2007
	sta	$2007
	
	lda	<PPU2001
	sta	$2001	;Turn screen back on

	rts

;----------------------------------------------------------------------------
Strobe_Cont:
	lda	<CONT1
	sta	<CONT1LAST

checkcont1:	ldx	#$01
	stx	$4016
	dex
	stx	$4016			;Strobe controller.


       	LDY   #$08
.readcontlp:
	tax
	LDA   $4016
	STA	<CONT1
	LSR     A
	ORA	<CONT1
	LSR     A
	txa
	ROL     A
	DEY
	BNE   .readcontlp
	sta	<CONT1

	lda	<CONT1LAST
	eor	#$FF
	and	<CONT1
	sta	<CONT1STROBE		;Save strobe.
	rts
;=====================================


Posn_Sprites:                  ;Put 4 cursor sprites on-screen
	lda	<MODE
	beq	.clrspr        ;If zero, clear positions
	cmp	#$03
	bmi	.pointpalbank
			;Now we're in mode 3
			
	lda	<CURSY
	asl	a
	asl	a
	asl	a
	asl	a
	adc	#$2F
	sta     <Spr_RAM        ;Y-pos1
	adc	#$08
	sta	<Spr_RAM+12     ;Y-pos2
	lda	<CURSX
	asl	a
	asl	a
	asl	a
	asl	a
	adc	#$30
	sta     <Spr_RAM+3      ;X-pos1
	adc	#$08
	sta	<Spr_RAM+15	;X-pos2
	bne     .write_sprites

;----------
.clrspr:
	lda	#$FF
	sta     <Spr_RAM        ;Y-pos1       ;Temporary Y-pos
	sta	<Spr_RAM+12     ;Y-pos2	;Temporary Y-pos2
	bne     .write_sprites

.pointpalbank:
	lda	<EDITPAL     ;0000xxxx
	asl	a
	asl	a
	asl	a
	asl	a
	sta	<Spr_RAM+3      ;X-pos1	;Our first x-position
	lda	#$CF            ;Sets the default Y-position
	sta     <Spr_RAM        ;Y-pos1
	lda	#$D7
	sta	<Spr_RAM+12     ;Y-pos2

.add_to_x:
	lda	#$07            ;Add to X-pos
	clc
	ldx	<MODE
	cpx	#$01
	bne	.notaddmore
	adc	#$30            ;Add 30 more if in Pal Bank mode
.notaddmore:
	adc	<Spr_RAM+3      ;X-pos1
	sta	<Spr_RAM+15	;X-pos2
;-----------
.write_sprites:
;-------------- sprite 1 Y
	ldy	<Spr_RAM        ;Y-pos1
;----------------- sprite 2 Y
	sty	<Spr_RAM+4	;Same Y-pos as spr 1
;-------------- sprite 1 X
	ldx	<Spr_RAM+3      ;X-pos1
 ;-------------- sprite 3 X
	stx	<Spr_RAM+11	;X-pos 1
 ;-------------- sprite 4 Y
	ldy	<Spr_RAM+12     ;Y-pos2
 ;-------------- sprite 3 Y
 	sty	<Spr_RAM+8
 ;-------------- sprite 4 X
	ldx	<Spr_RAM+15	;X-pos2
;----------------- sprite 2 X
	stx	<Spr_RAM+7

	rts
;============================================================================


Setup_PPU
	jsr	Init_CHR	;Blank out CHR/NAM/ATT and put tile gfx in!
	jsr	Init_ATT	;Inits a basic ATT table.
	jsr	Draw_Backdrop	;Fills the backdrop with a pattern or picture.
	jsr	FillGBTiles	;Fills in the GB screen itself
	lda	<MODE
	beq	.no_show_pal    ;If in edit mode, draw palette nums
	jsr	Draw_Edit_Scr
.no_show_pal:
  ;--------------------------
	lda	#$00
	jsr     SetPal
	lda	#$01
	jsr     SetPal
	lda	#$02
	jsr     SetPal
	lda	#$03
	jsr     SetPal

	rts
;==============================================
Draw_Backdrop:                  ;Draws a backdrop graphic around the GB screen.
	lda     <BDROP_NUM
	cmp	#$04		;Is it 0-3 (each BG colour)
	bmi	.draw_solid

	;Do the GB-like screen here
	jsr	Draw_GB_Bdrop
	jsr	Draw_Borders    ;Draws the border around the GB screen (optional?)
	ldx	#BORDPAL		;First palette in the border palette
	stx	<PALNUM3
	ldx	#$00				;2nd palette in the border palette
	stx	<PALNUM4
	rts
;----------
.draw_solid:  	;Draw a solid pattern for the backdrop
        ldx	#$20
	stx	$2006
	ldx	#$00
	stx	$2006		;Point to NAM table
	ldy	#$03		;$3C0 times, hopefully...
	ldx	#$C0
	clc
	adc	#$FC		;Point to one of the solid colours...
	jsr     Fill_Byte   	;fill NAM ***
	rts
;-----------------------

FillGBTiles:
	lda	#$C6
	sta	<PPUADDR	;This is the low byte!
	lda	#$20
	sta	<PPUADDR+1	;this is the high byte!

       	lda	#$00		;Initial Character value...
	jsr	FillGBInner
	lda	#$00		;Initial Character value...
	jsr	FillGBInner
	rts
;------------------
FillGBInner:
	ldy	#9		;9 lines per run
.outerloop:
	ldx     <PPUADDR+1	;set write
	stx	$2006
	ldx	<PPUADDR
	stx	$2006

	ldx	#20		;20 characters across
.innermost:
	sta	$2007		;Save character value
	clc
	adc	#$01		;INC A
	dex
	bne     .innermost
;--
	tax
	lda     <PPUADDR
	clc
	adc	#$20
	sta	<PPUADDR
	lda	<PPUADDR+1
	adc	#$00
	sta	<PPUADDR+1
	txa
;--
	dey
	bne	.outerloop
	rts
;@@@@@@@@@@@@@@

Fill_Byte: 	;Fills PPU VRAM with byte A for Y,X loops
	cpx     #$00
	bne	.noadjY
	dey		;This is a KLUDGE to account for X=0
.noadjY:
	sta	$2007
	dex
	bne	.noadjY
	dey
	bpl	.noadjY
	rts
;@@@@@@@@@@@@@@@@@@

SetPal:		;Updates the palette # in A
	ldx	#$3F
	stx	$2006
	tax		;Palette # (0..3) is saved
	asl	a
	asl	a	;Point into PPU
	sta	$2006	;Point to Palette
	lda	<PALNUM1,X	;Get the current palette pointer
	asl	a
	asl	a	;Index into 4 pal entries
	tax
	lda     Palettes,X
	sta	$2007
	lda     Palettes+1,X
	sta	$2007
	lda     Palettes+2,X
	sta	$2007
	lda     Palettes+3,X
	sta	$2007		;That's 4 written...
	rts
;=======================================================

Init_CHR:
	lda	#$00
	sta	$2006
	sta	$2006		;Point to CHR table
	ldy	#$23		;$2400 times, hopefully...
	ldx	#$C0
 ; 	lda	#$00
	jsr     Fill_Byte   	;CHR fill *** & NAM fill too! ***
 ;--------------------------
	lda	#$0F
	sta	$2006
	lda	#$D0
	sta	$2006		;Point to CHR table
	ldy	#$00		;8 times, hopefully...
	ldx	#8
  	lda	#$FF
	jsr     Fill_Byte   	;2nd part of CHR fill
;-----------------------------------
 	lda	#$0F
	sta	$2006
	lda	#$E8
	sta	$2006		;Point to CHR table
	ldy	#$00		;24 times, hopefully...
	ldx	#24
  	lda	#$FF
	jsr     Fill_Byte   	;last part of CHR fill
;---------------------------------
	lda	#$0B
	sta	$2006
	lda	#$F8 	;Point to CHR BF
	sta	$2006
	lda	#$FF
	sta	$2007
	ldx	#$07
	lda	#$80
.chrlp3:
	sta	$2007    ;Write in Cursor sprite tile...
	dex
	bne	.chrlp3
;------------------------------
;	lda	#$0C
;	sta	$2006
;	lda	#$00
;	sta	$2006

;------ 1st CHR section...
	ldx	#$28            ;Load $D8 bytes from LOOOW RAM...
.chrlp1:
	lda     <$00,X
	sta	$2007
	inx
	bne     .chrlp1

;------ 2st CHR section...
	ldx	#$58            ;Load $A8 bytes...
.chrlp2:
	lda     GB_Tiles-$58,X
	sta	$2007
	inx
	bne     .chrlp2

	rts

Draw_Borders:
 	lda	#$20
	sta	$2006
	lda	#$A5
	sta	$2006		;Point to NAM table
	ldy	#$00		;22times, hopefully...
	ldx	#22
  	lda	#$FC
	jsr     Fill_Byte   	;Border drawing
 ;--------------------------
	lda	#$23
	sta	$2006
	lda	#$05
	sta	$2006		;Point to NAM table
	ldy	#$00		;22times, hopefully...
	ldx	#22
  	lda	#$FC
	jsr     Fill_Byte   	;Border drawing
;--------------------------
	lda     <PPU2000
	eor	#%00000100	;Change to vertical NAM writing
	sta	$2000

	lda	#$20
	sta	$2006
	lda	#$C5
	sta	$2006		;Point to NAM table
	ldy	#$00		;18 times, hopefully...
	ldx	#18
  	lda	#$FC
	jsr     Fill_Byte   	;Vertical Border drawing
	lda	#$20
	sta	$2006
	lda	#$DA
	sta	$2006		;Point to NAM table
	ldy	#00		;18 times, hopefully...
	ldx	#18
  	lda	#$FC
	jsr     Fill_Byte   	;Vertical Border drawing

 	lda     <PPU2000
	sta	$2000           ;Restore previous value.
	rts
;--------------------------

Init_ATT:
	lda	#$23 		;Point to ATT position
	sta	$2006
	lda	#$C0
	sta	$2006
	ldx	#$00
.attlp1:	lda Init_Att1,X
	sta	$2007
	inx
	cpx	#$10		;Write first unique ATT data
	bne     .attlp1

	ldy	#$04
.attlp2:
	ldx	#$00
.attlp3:	lda Init_Att2,X
	sta	$2007
	inx
	cpx	#$08		;Write second unique ATT data
	bne     .attlp3
	dey
	bne     .attlp2
	rts
;-------------------------------------------------------------------------------

Draw_GB_Bdrop:                ;Decodes the RLE'd data and puts it on the screen

	lda	#$20
	sta	$2006
	lda	#$00
	sta	$2006	;Go to NAM table
	
	lda	#LOW(GB_RLE1)		;Point to first data table
	sta     <PPUADDR
	lda	#HIGH(GB_RLE1)
	sta     <PPUADDR+1
	jsr     RLE_Decode
	
	lda	#LOW(GB_RLE2)		;Point to 2nd data table
	sta     <PPUADDR
	lda	#HIGH(GB_RLE2)
	sta     <PPUADDR+1
	
	lda	#23			;Repeat this 23 times
	sta     <TEMPBYT1
.gb_loop1:
	jsr     RLE_Decode
	dec	<TEMPBYT1
	bne	.gb_loop1
	
	lda	#LOW(GB_RLE3)		;Point to 3rd data table
	sta     <PPUADDR
	lda	#HIGH(GB_RLE3)
	sta     <PPUADDR+1
	jsr     RLE_Decode
	
	lda	#LOW(GB_RLE4)		;Point to 4th data table
	sta     <PPUADDR
	lda	#HIGH(GB_RLE4)
	sta     <PPUADDR+1
	jsr     VWrite_Decode
	rts
;=============================
RLE_Decode: 		;byte: 01-7F = run length; 80-FF = data; 0 = end
	ldy	#$00
.rle_loop0:
	ldx	#$01		;(A default counter...)
.rle_loop1:
	lda	[PPUADDR],Y 	;Get next byte
	beq	.rle_end        ;If zero, exit
	bmi	.write_data	;If 80-FF, write it!
.load_counter:
	tax			;Copy the byte to the X counter
	iny
	bne	.rle_loop1      ;We can branch 'cause it's always 01-FF
.write_data:
	sta	$2007           ;Write the byte to the PPU
	dex                     ;Decrement our counter
	bne     .write_data     ;Repeat it...
	iny                     ;(Go to next byte in stream...)
	bne	.rle_loop0      ;We can branch 'cause it's always 01-FF
.rle_end:
	rts
	
VWrite_Decode:
	ldy	#$00
.vwr_loop0:
	lda	[PPUADDR],Y 	;Get next byte
	beq	.wrt_end        ;If zero, exit
	and	#$F0
	cmp	#$20		;Is it an address?
	beq	.write_ppu_add
        lda	[PPUADDR],Y 	;Get byte again
        sta	$2007           ;Write to $2007
        iny
        bne     .vwr_loop0
.write_ppu_add:
        lda	[PPUADDR],Y 	;Get byte again
        sta	$2006           ;Set address
        iny
        lda	[PPUADDR],Y 	;Get 2nd address byte
        sta	$2006
        iny
        bne     .vwr_loop0
.wrt_end:
	rts

;---------------------
Sprite_Write:	ldx	#$00
	stx	$2003	;Write to PPU Sprite Address
.spr_lp1:
	lda	<Spr_RAM,X
	sta	$2004
	inx
	cpx	#$10
	bne     .spr_lp1
	rts
;=====================================================================
;=====================================================================
Init_Att1:	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
		DB $FF,$3F,$0F,$0F,$0F,$0F,$CF,$FF
Init_Att2:	DB $FF,$33,0,0,0,0,$CC,$FF
;GB_Att1_RLE:	DB $BF,$04,$AF,$EF,$BF,$EF,$00	;GB_Att1_:	DB $BF,$AF,$AF,$AF,$AF,$EF,$BF,$EF

Palettes:
	DB	$20,	$10,	$00,	$0F		;(first) Border palette & Greyscale
	DB	$38,	$28,	$19,	$09		;GB-like
	DB	$39,	$29,	$19,	$09		;Spinach Green
	DB	$31,	$21,	$11,	$01		;Blue 1
	DB      $33,	$23,	$13,	$03             ;Blue-Purple
	DB	$35,	$25,	$15,	$05		;Magenta-Red
	DB      $30,	$28,	$18,	$08             ;White-Yellow

	DB      $30,	$27,	$16,	$01             ;Super Game Boy-like
;	DB	$30,    $27,	$16,	$0F		;White-Red-Black
	DB      $30,	$23,	$13,	$0F             ;White-Blue-Black
	DB      $0C,	$1C,	$2C,	$3C             ;Negative-like
;------------------------------------------------------------
BorderPal:
	DB	$20,	$16,	$00,	$02		;2nd GB screen palette.
BORDPAL = (BorderPal-Palettes)/4	;Point to first border palette

;The following is a mixed Run-Length Encoded NAM table
GB_RLE1:        .incbin	"GBRLE1.bin"	;byte: 01-7F = run length; 80-FF = data; 0 = end
GB_RLE2:        .incbin	"GBRLE2.bin"	;as above, but repeat it 23 times
GB_RLE3:        .incbin	"GBRLE3.bin"    ;simple RLE as above
GB_RLE4:        DB $23,$D0,$BF		;ATT byte for LED (1 byte at $23D0)
		DB $23,$C0,$BF,$AF,$AF,$AF,$AF,$EF,$BF,$EF ;ATT for GB lines (at $23C0)
		.incbin	"GBRLE4.bin"	;PPU ADDR, Data...  (if 1st byte is $2x, it's an address.)
GB_Tiles: 	.incbin "GBTILES-hi.bin" 	;CHR tiles for the GB backdrop