;Chris Covell's Wide Boy replacement ROM!
;This code mostly loads the main program into the FC's RAM.

; INES header setup
        .inesprg    1
        .ineschr    0
        .inesmir    1
        .inesmap    0

        ZP

        CODE

        .bank 0		;These are 8KB banks in NESASM!  Stupid, eh?
        .org $C000
	DB $EE
	.bank 1
	.org $E000

RAM_Code = $0110		;This is really low in RAM!

PPU2005V = $00FC
PPU2005H = $00FD
PPU2001 = $00FE
PPU2000 = $00FF
NMI_PASS = $56		;Has NMI passed?
VBCOUNT = $57
;

_Relocate_Code				;The code to be relocated!
	incbin "RAM.BIN"
 ;	.end			;End of Relocated code!!!!!


Reset_SUB
	cld
	sei
	lda	#$00
	sta	$2000
	sta	<PPU2000
	sta	$2001
	sta	<PPU2001

waitvb1:	lda	$2002		;Wait for VBlank to end
	bmi	waitvb1
waitvb2:	lda	$2002		;Wait for VBlank to start again
	bpl	waitvb2
waitvb3:	lda	$2002		;Wait for VBlank to end
	bmi	waitvb3
waitvb4:	lda	$2002		;Wait for VBlank to start again
	bpl	waitvb4
waitvb5:	lda	$2002		;Wait for VBlank to end
	bmi	waitvb5
waitvb6:	lda	$2002		;Wait for VBlank to start again
	bpl	waitvb6

	ldx	#$0F			;Stack will be 16 bytes only!
	txs				;(Should be enough...)

	jsr	Init_Clear_PPU		;Clear up 2 name tables!

	ldy	#$07
	sty	<$01
	ldy	#$00
	sty	<$00
	lda	#$00

clrram1:	sta	[$00],y	;Clear all RAM
	dey
	bne	clrram1
	dec	<$01
	bpl	clrram1

	ldx	#$00
	stx	<NMI_PASS

	;Copy code to RAM
	ldx	#$00
copy_low:
        lda	_Relocate_Code,X        ;Copy .75 pages of ROM to RAM
	sta	RAM_Code,X
	inx
	cpx	#$F0
	bne     copy_low
;---
	ldx	#$00
copycode:
	lda	_Relocate_Code+$F0,X        ;Copy 6 pages of ROM to RAM
	sta	RAM_Code+$F0,X
	lda	_Relocate_Code+$1F0,X	;from $0200-$07FF
	sta	RAM_Code+$1F0,X
	lda	_Relocate_Code+$2F0,X
	sta	RAM_Code+$2F0,X
	lda	_Relocate_Code+$3F0,X
	sta	RAM_Code+$3F0,X
	lda	_Relocate_Code+$4F0,X
	sta	RAM_Code+$4F0,X
	lda	_Relocate_Code+$5F0,X
	sta	RAM_Code+$5F0,X
	inx
	bne	copycode
	
	ldx	#$28            ;Load CHR tiles into RAM...
.chrlp2:
	lda     GB_Tiles_Lo-$28,X
	sta	<$00,X
	inx
	bne     .chrlp2
	
.spr_lp2:
	lda    Spr_Att,X
	sta	<$00,X	;Save sprite defs to LOW RAM
	inx
	cpx	#$10
	bne    .spr_lp2


	jmp	RAM_Code	;Jump to RAM_Code address!


;********************************************************************

;********************************************


;------------------------------- SUBROUTINES ---------------

NMI_SUB
	php
	pha
	txa
	pha
	tya
	pha

	lda	#$01
	sta	<NMI_PASS
	INC	<VBCOUNT

	pla
	tay
	pla
	tax
	pla
	plp
	rti

;----------------
;

IRQ_SUB
	rti

Init_Clear_PPU
	lda	#$20
	sta	$2006
	lda	#$00
	sta	$2006

	ldy	#$0B
	sty	$0001
	ldy	#$00
	sty	$0000
	lda	#$00

cppu1	sta	$2007	;Clear 2 PPU NAM tables
	dey
	bne	cppu1
	dec	$0001
	bpl	cppu1

	lda	#$23		;Point to attribute table
	sta	$2006
	lda	#$C0
	sta	$2006

	ldy	#$40
	lda	#$00		;This gives me the pattern I want.
att_loop	sta	$2007
	dey
	bne	att_loop
	
	lda	#$3F
	sta	$2006
	lda	#$11	;1st sprite PAL position
	sta	$2006
	lda	#$15    ;Red-Orange
	sta	$2007
	sta	$2007
	sta	$2007

	lda	#$FF
	ldx	#$00
	stx	$2003	;Write to PPU Sprite Address
.spr_lp:	sta	$2004	;Fill out SPR-RAM with FCs (blank tile, offscreen)
	inx
	bne	.spr_lp
	
	rts
	
GB_Tiles_Lo: 	.incbin "GBTILES-lo.bin" 	;CHR tiles for the GB backdrop
Spr_Att:	DB $FF,$BF,$00,$FF, $FF,$BF,$40,$FF, $FF,$BF,$80,$FF, $FF,$BF,$C0,$FF
;-----------
	.org $FFFA
	.dw NMI_SUB
	.dw Reset_SUB
	.dw IRQ_SUB