;
; WAVY.ASM
;

_xres	.equ 320	; set this before including 'startup.asm'
			; that will set up a 320x240 screen in place
			; of the default 256x240 screen

	.include "startup.asm"
	.nomlist
	.list

; ----
; defines

NB_PICS	.equ 1		; the number of pictures in the slideshow

; ----
; variables

	.zp
pic:	.rs  1		; the current picture number
scanline:	.ds 2	; the line number for the scanline interrupt
sinevalue: .ds 1	;Some temporary val for the sine wave.

	; wavy scroll

wave_base:	.ds 1	; base index for the wave table
wave_idx:	.ds 1	; index in the wave table
wave_delay:	.ds 1   ; delay for wave scrolling


;[ MAIN CODE ]

	.code
	.bank MAIN_BANK
	.org  $C000
main:
	; disable display

	vsync
	vreg  #5
	lda   #$0C
	sta   $0002

	; load the picture in VRAM

	jsr	load_pic

	; enable display

	vsync
	vreg  #5
	lda   #$CC
	sta   $0002

	; wait that the user presses a button

	vsync
.l1:

;	tst  #$03,joydlta	; button pressed?
;	beq  .l1

	lda	#$02
	sta	<wave_delay

	; OK next picture, loop if was the last one

	setvec #VSYNC,vsync_proc
	setvec #HSYNC,hsync_proc
	vec_on #VSYNC
	vec_on #HSYNC

.waitstate

	jmp   .waitstate

;**************************************************
;------ Interrupt code --------------------------

; ----
; vsync_proc
; ----
; called every VSYNC
; ----

vsync_proc:
	st0   #6		; restart the scanline counter on the first
	stw   #$40,video_data	; line
	stw   #$40,<scanline
	lda   <wave_base	; change the index base for the wavy
	add   #2		; scrolling
	sta   <wave_base
	sta   <wave_idx

;---------------------------
; enable display
;	vreg  #5
;	lda   #$CC
;	sta   $0002
;----------------------
	rts

; ----
; hsync_proc
; ----
; called every HSYNC
; ----

hsync_proc:

	; update the scrolling

	st0   #8		; This means Y-scroll!
	lda   <wave_idx
	lsr   A
	lsr   A
	tax
	lda   .wave,X
;	asl	A
;	lsr	A
	sta	<sinevalue

;	clc
;	adc	#$80
;	lsr	A
;	lsr	A
	sta	<sinevalue	;Get sine data from wherever

;-----------------------
	lda	<scanline
	sec
	sbc	#$40
	clc
	adc	<sinevalue	;Add it to a ramp (for each scanline)
;-----------------------	
	sta   video_data
	stz   video_data+1
	
	lda   <wave_idx
	lsr   A
	lsr   A
	tax
	lda   .firewave,X
	st0	#7		;This means X-scroll!
	sta   video_data
	stz   video_data+1
.update:
;	lda   <scanline		; update index in the
;	bit   #$03		; wave table
;	bne   .scanline
	inc     <wave_idx


	; reprogram the scanline counter for the next line

.scanline:
	st0   #6
	incw  <scanline
	stw   <scanline,video_data
;-----------------------------------------
;	lda	<scanline+1
;	cmp	#$01
;	bne	.NoBlankScreen
;	lda	<scanline
;	cmp	#$10
;	bne	.NoBlankScreen
;
;	; disable display
;	vreg  #5
;	lda   #$0C
;	sta   $0002
;
;.NoBlankScreen
;-----------------------------------------
	rts

	; the wave table

.wave:	.db   5,6,7,8,8,9,9,10,10,10,9,9,8,8,7,6
	.db   5,4,3,2,2,1,1,0,0,0,1,1,2,2,3,4
	.db   5,6,7,7,8,8,9,9,9,9,9,8,8,7,7,6
	.db   5,4,3,3,2,2,1,1,1,1,1,2,2,3,3,4

.sinetbl 	.include "sin.inc"
.firewave	.include "firewave.asm"


;[ SUB CODE ]

; ----
; load_pic
; ----
; upload a whole pic in VRAM
; ----

load_pic:
	lda   <pic		; get the current pic number

	asl   A			; mul it by 6 (each picture takes six banks,
	sta   <_al		; five for the graphics and one for the BAT
	asl   A			; and the palette)
	add   <_al

	add   #2		; add 2 - our pictures are stored starting
				; from bank 2

	sta   <_ah		; store the bank index

	; load the graphic in VRAM, one bank at a time
	
	lda   <_ah		; first bank
	tam   #4
	vload $1000,$8000,#$1000
	inc   <_ah		; second bank
	lda   <_ah
	tam   #4
	vload $2000,$8000,#$1000
	inc   <_ah		; third bank
	lda   <_ah
	tam   #4
	vload $3000,$8000,#$1000
	inc   <_ah		; fourth bank
	lda   <_ah
	tam   #4
	vload $4000,$8000,#$1000
	inc   <_ah		; fifth bank
	lda   <_ah
	tam   #4
	vload $5000,$8000,#$1000

	; vsync before setting the palette, to avoid snow

	vsync

	; now set the palette

	inc   <_ah
	lda   <_ah
	tam   #4
	set_bgpal #0,$8000,#16

	; and finaly copy the BAT

	batcpy $0,\
	       #64,\
	       $8200,\
	       #40,\
	       #32

	; ok, done

	rts


;[ PICTURE DATA ]

	.data

	; pictures can contain up to 256 colors, but as you know the
	; PC-Engine can display only 16 colors per 8x8 tile, so be careful
	; when making pictures. And also take care of the color alignment,
	; a tile can use, for example, color 0 to 15, but not color 4 plus
	; color 26 plus color 125, all the colors used in a tile must
	; belong to the same sub-palette (colors 0 - 15, 16 - 31, etc...)
        ;
	; if you have problems making such pictures, use only 16 colors
	; PCX files, you will have less problems

PIC_BANK .func (((\1)*6)+MAIN_BANK+1)	; a little function to help
					; referencing banks

PIC	.macro			; hmm a macro could be handy too...
	 .bank PIC_BANK(\1)
	 .org  $8000
	 .incchr \2,40,32
	 .bank PIC_BANK(\1)+5
	 .org  $8000
	 .incpal \2
	 .org  $8200
	 .incbat \2,$1000,40,32
	.endm

	PIC 0,"flag.pcx"	; what would we do without macros? :)

	; etc... up to 21 pictures.
	;
	; at your turn now, make us some cool slideshow!

