;
; SLIDSHOW.ASM
;

_xres	.equ 320	; set this before including 'startup.asm'
			; that will set up a 320x240 screen in place
			; of the default 256x240 screen

	.include "startup.asm"
	.nomlist
	.list

; ----
; defines

NB_PICS	.equ 4		; the number of pictures in the slideshow

; ----
; variables

	.zp
pic:	.rs  1		; the current picture number


;[ MAIN CODE ]

	.code
	.bank MAIN_BANK
	.org  $C000
main:
	; disable display

	vsync
	vreg  #5
	lda   #$0C
	sta   $0002

	; load the picture in VRAM

	jsr	load_pic

	; enable display

	vsync
	vreg  #5
	lda   #$CC
	sta   $0002

	; wait that the user presses a button
.l1:
	vsync			; synchro

	tst  #$03,joydlta	; button pressed?
	beq  .l1

	; OK next picture, loop if was the last one

	inc   <pic
	lda   <pic
	cmp   #NB_PICS
	blo   main
	stz   <pic
	jmp   main


;[ SUB CODE ]

; ----
; load_pic
; ----
; upload a whole pic in VRAM
; ----

load_pic:
	lda   <pic		; get the current pic number

	asl   A			; mul it by 6 (each picture takes six banks,
	sta   <_al		; five for the graphics and one for the BAT
	asl   A			; and the palette)
	add   <_al

	add   #2		; add 2 - our pictures are stored starting
				; from bank 2

	sta   <_ah		; store the bank index

	; load the graphic in VRAM, one bank at a time
	
	lda   <_ah		; first bank
	tam   #4
	vload $1000,$8000,#$1000
	inc   <_ah		; second bank
	lda   <_ah
	tam   #4
	vload $2000,$8000,#$1000
	inc   <_ah		; third bank
	lda   <_ah
	tam   #4
	vload $3000,$8000,#$1000
	inc   <_ah		; fourth bank
	lda   <_ah
	tam   #4
	vload $4000,$8000,#$1000
	inc   <_ah		; fifth bank
	lda   <_ah
	tam   #4
	vload $5000,$8000,#$1000

	; vsync before setting the palette, to avoid snow

	vsync

	; now set the palette

	inc   <_ah
	lda   <_ah
	tam   #4
	set_bgpal #0,$8000,#16

	; and finaly copy the BAT

	batcpy $0,\
	       #64,\
	       $8200,\
	       #40,\
	       #30

	; ok, done

	rts


;[ PICTURE DATA ]

	.data

	; pictures can contain up to 256 colors, but as you know the
	; PC-Engine can display only 16 colors per 8x8 tile, so be careful
	; when making pictures. And also take care of the color alignment,
	; a tile can use, for example, color 0 to 15, but not color 4 plus
	; color 26 plus color 125, all the colors used in a tile must
	; belong to the same sub-palette (colors 0 - 15, 16 - 31, etc...)
        ;
	; if you have problems making such pictures, use only 16 colors
	; PCX files, you will have less problems

PIC_BANK .func (((\1)*6)+MAIN_BANK+1)	; a little function to help
					; referencing banks

PIC	.macro			; hmm a macro could be handy too...
	 .bank PIC_BANK(\1)
	 .org  $8000
	 .incchr \2,40,30
	 .bank PIC_BANK(\1)+5
	 .org  $8000
	 .incpal \2
	 .org  $8200
	 .incbat \2,$1000,40,30
	.endm

	PIC 0,"Outrun1a.pcx"	; what would we do without macros? :)
	PIC 1,"Outrun1-16cols.pcx"
	PIC 2,"Allcolours.pcx"
	PIC 3,"turbologo.pcx"

	; etc... up to 21 pictures.
	;
	; at your turn now, make us some cool slideshow!

