
encode:
	;; start by scrambling the address
	lda	#$00
	sta	result
	sta	result+1
	sta	result+2
	sta	result+3
	ldy	#14
e_addr:	clc
	lda	desc_alo,y
	bit	tmp_addr
	bne	enc_addr_bit
	lda	desc_ahi,y
	bit	tmp_addr+1
	beq	enc_addr_shift
enc_addr_bit:
	sec
enc_addr_shift:
	ror	result+2
	ror	result+3
	dey
	bpl	e_addr

	;; now scramble the compare
	ldy	#7
e_comp:	lda	desc_comp,y
	bit	tmp_compare
	clc
	beq	enc_comp_shift
	sec
enc_comp_shift:
	ror	result+1
	dey
	bpl	e_comp

	;; now scramble the value
	ldy	#7
e_val:	lda	desc_val,y
	bit	tmp_value
	clc
	beq	enc_val_shift
	sec
enc_val_shift:
	ror	result
	dey
	bpl	e_val

	;; finalize the scrambled value and initialize the decoder
	ror	result
	ror	result+1
	ror	result+2
	ror	result+3
	lda	#0
	sta	decoder
	sta	decoder+1
	sta	decoder+2
	sta	decoder+3

	;; now we run the decoder backwards
	ldy	#31
enc_loop:
	lsr	decoder
	ror	decoder+1
	ror	decoder+2
	ror	decoder+3
	lsr	result
	ror	result+1
	ror	result+2
	ror	result+3
	bcc	enc_no_bit

	lda	#$b8
	eor	decoder
	sta	decoder
	lda	#$30
	eor	decoder+1
	sta	decoder+1
	lda	#$97
	eor	decoder+2
	sta	decoder+2
	lda	#$22
	eor	decoder+3
	sta	decoder+3
enc_no_bit:
	dey
	bne	enc_loop

	;; And now mask in the base value and clean up the results.
	lda	#$fc
	eor	decoder
	sta	code
	lda	#$bd
	eor	decoder+1
	sta	code+1
	lda	#$d2
	eor	decoder+2
	sta	code+2
	lda	#$75
	eor	decoder+3
	and	#$fe
	sta	code+3

	rts

	;; EOF
