; INES header setup
;        .inesprg    1		;For other sucky assemblers!!!
;        .ineschr    1
;        .inesmir    1
;        .inesmap    0
;
;        .bank 0
;        .org $C000      ;
;                        ; 
;

;.MEM	8
;.INDEX	8
;.OPT	ON
;.ORG	$C000

SPR_RAM = $0700
CURS_SPRY = SPR_RAM+4
CURS_SPRFlip = SPR_RAM+6
CURS_SPRX = SPR_RAM+7
LETTER_TILES = SPR_RAM+$61
SCROLL_SPR = SPR_RAM+$A0
;
PPU2005V = $00FC
PPU2005H = $00FD
PPU2001 = $00FE
PPU2000 = $00FF
;

.zeropage
dummyadd: .res 2
pointer: .res 2

CONTROLLER1: .res 1	;7-> A,B,SL,ST,U,D,L,R <-0
CONTROLLER2: .res 1
CONT1LAST: .res 1	;Reading of the last controller
CONT2LAST: .res 1
CONT1STROBE: .res 1
CONT2STROBE: .res 1
NMI_PASS: .res 1		;Has NMI passed?
VBCOUNT: .res 1
UPDATEDELAY: .res 1
SCROLLERPOS: .res 1
SCROLLERLIN: .res 1
NEON_POS: .res 1	;Position in the colour index
CURSOR_LIGHT: .res 1	;Is the cursor blinking?
CURSOR_POS: .res 1	;Cursor position: 0..7: Rocky, 8..F: Decode
ACTION_FLAG: .res 1	;Action to do:	001: update sprites
			;		010: decode code
			;		100: encode code
			;		????

code: .res 4	;The Rocky CODE!!!!!
value: .res 1	;The data value of the decoded code
compare: .res 1	;The compare byte of the decoded code
addr: .res 2	;The decoded address
;-------- ROCKY STUFF!!! -------
tmp_code: .res 4	;The Rocky CODE!!!!!
tmp_value: .res 1	;The data value of the decoded code
tmp_compare: .res 1	;The compare byte of the decoded code
tmp_addr: .res 2	;The decoded address
decoder: .res 4
result: .res 4
;-------------------------------
NOISE_FREQ: .res 1	;The actual frequency
NOISE_VOL: .res 1	;The actual volume
VOL_COUNTDOWN: .res 1	;A countdown timer for changing volume.
VOL_DIRECTION: .res 1	;A bit for the direction of the change.
FREQ_COUNTDOWN: .res 1	;A countdown timer for changing frequency.
FREQ_DIRECTION: .res 1	;A bit for the direction of the change.
FREQ_LIMIT: .res 1	;A limit for the upper frequency!
;---------------------------------------


.segment "RAM"

;--------------------------------------------------------------
.segment "CODE"
.org $C000

Reset_SUB:
	cld
	sei
	ldx	#$FF
	txs

	lda	#$00
	sta	$2000
	sta	PPU2000
	sta	$2001
	sta	PPU2001

Clear_RAM:
	ldy	#$07
	sty	$0001
	ldy	#$00
	sty	$0000
	lda	#$00

clrram1:	sta	($00),y	;Clear all RAM
	dey
	bne	clrram1
	dec	$0001
	bpl	clrram1

;	jsr	FDS_HOOK	;If this is running on the FDS.

	jsr	Wait_1_VB
	jsr	Wait_1_VB

	jsr	Init_Clear_PPU		;Clear up 2 name tables!
	jsr	Setup_PPU
	jsr	Wait_1_VB

	lda	#%10001000	;NMI, Sprite at $1000
	sta	$2000
	sta	PPU2000
	lda	#%00011110	;BG, Sprites on, No clipping
	sta	$2001
	sta	PPU2001
;=====================================
	lda	#$00
	sta	code
	sta	code+1
	sta	code+2
	sta	code+3
	sta	value
	sta	compare
	sta	addr
	sta	addr+1

	lda	#$03
	sta	ACTION_FLAG
	lda	#$16
	sta	CURSOR_LIGHT

	jsr	Init_Sound
	
;====================================	

	ldx	#$00
	stx	NMI_PASS
	stx	$2005
	stx	PPU2005V
	stx	$2005
	stx	PPU2005H
	
mainloop:
	lda	NMI_PASS
	beq	mainloop	;NMI has passed if it's 1
	lda	#$00
	sta	NMI_PASS

	jsr	ControllerAction

	lda	ACTION_FLAG
	and	#$04		;Check Decode Code?
	beq	NoEncodeCode
	jsr	Rocky_EncodeCode
NoEncodeCode:
	lda	ACTION_FLAG
	and	#$02		;Check Decode Code?
	beq	NoDecodeCode
	jsr	Rocky_DecodeCode
NoDecodeCode:
	lda	ACTION_FLAG
	and	#$01		;Check update sprites?
	beq	NoUpdateSprites
	jsr	Update_Sprites
NoUpdateSprites:

	lda	VBCOUNT
	and	#$07
	bne	NoUpdateScroller	;Do it only if it's 000
	jsr	UpdateScroller
NoUpdateScroller:
	jmp	mainloop

;---------------------------



;--------------------------------------------------
;***********************************************
;***********************************************
;--------------------------------------------------
NMI_SUB:
	php
	pha
	txa
	pha
	tya
	pha

	lda	#$01
	sta	NMI_PASS
	INC	VBCOUNT

	jsr	FDS_HOOK

	lda	#$00
	sta	$2003		;Reset spr-ram pointer
	lda	#$07
	sta	$4014		;copy sprites every NMI

	jsr	Check_Controller
	jsr	Cycle_Colours
	jsr	Change_Sound

	lda	#$00
	sta	$2006
	sta	$2006
	sta	$2005
	sta	$2005

	pla
	tay
	pla
	tax
	pla
	plp
	rti
IRQ_SUB:
	rti

;---------------- SUBROUTINES -------------------
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;------------------------------------------------

Rocky_DecodeCode:
	lda	ACTION_FLAG
	eor	#$02		;Reset the flag!
	sta	ACTION_FLAG

	lda	code
	sta	tmp_code
	lda	code+1
	sta	tmp_code+1
	lda	code+2
	sta	tmp_code+2
	lda	code+3
	sta	tmp_code+3

	.include "Rocky_Decode_SUB.asm"
;IT SHOULD HAVE RTSed, but just in case....
	rts

Rocky_EncodeCode:
	lda	ACTION_FLAG
	eor	#$04		;Reset the flag!
	sta	ACTION_FLAG

	lda	value
	sta	tmp_value
	lda	compare
	sta	tmp_compare
	lda	addr
	sta	tmp_addr
	lda	addr+1
	sta	tmp_addr+1

	.include "Rocky_encode_sub.asm"
;IT SHOULD HAVE RTSed, but just in case....
	rts

desc_val:   .byte $10, $08, $40, $02, $04, $01, $80, $20
desc_comp:  .byte $04, $01, $02, $10, $40, $80, $20, $08
desc_ahi:   .byte $00, $08, $04, $01, $00, $00, $10, $00
            .byte $00, $02, $00, $00, $40, $20, $00
desc_alo:   .byte $10, $00, $00, $00, $04, $80, $00, $01
            .byte $20, $00, $40, $02, $00, $00, $08
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

Init_Sound:
	lda	#$08
	sta	$4015		;Noise channel enable
	lda	#$00
	sta	NOISE_VOL
	ora	#%00110000	;This should DISable envelope?
	sta	$400C
	lda	#$00
	sta	NOISE_FREQ
	sta	$400E
	lda	#$00
	sta	$400F		;I hope this is OK?

	lda	#$00
	sta	FREQ_LIMIT	;This might be clobbered

	rts

Change_Sound:
	lda	VOL_COUNTDOWN
	bne	NoChangeVolume
	lda	value			;Get it from the decoded code!
	and	#$3F
	clc
	adc	#$05			;Add a little bit more.
	sta	VOL_COUNTDOWN

	lda	VOL_DIRECTION		;0=up, 1=down
	bne	DecreaseVol
	inc	NOISE_VOL
	lda	NOISE_VOL
	cmp	#$0A			;Maximum to my taste
	bne	NoChangeDirectionDown
	lda	#$01
	sta	VOL_DIRECTION		;Start going down now
NoChangeDirectionDown:
	jmp	ContinueVol
DecreaseVol:
	dec	NOISE_VOL
	bne	NoChangeDirectionUp	;Branch if still nonzero
	lda	#$00
	sta	VOL_DIRECTION		;Start going up now
NoChangeDirectionUp:
ContinueVol:
	lda	NOISE_VOL
	and	#$0F
	sta	NOISE_VOL
	ora	#%00110000	;This should DISable envelope?
	sta	$400C
NoChangeVolume:
	dec	VOL_COUNTDOWN
;- - - - - - - - - - - - - - - - - - - - -
	lda	FREQ_COUNTDOWN
	bne	NoChangeFreq
	lda	addr			;Get it from the decoded code!
	and	#$EF
	clc
	adc	#$07			;Add a little bit more.
	sta	FREQ_COUNTDOWN

	lda	FREQ_DIRECTION		;0=up, 1=down
	bne	DecreaseFreq
	inc	NOISE_FREQ
	lda	NOISE_FREQ
	cmp	#$0F			;Minimum frequency
	bne	NoChangeFrDirectionDown
	lda	#$01
	sta	FREQ_DIRECTION		;Start going down now
	lda	compare			;Get limit from the decoded code!
	and	#$0E			;Can't be $0F!  ($00 doesn't matter)
	sta	FREQ_LIMIT		;Time to get the upper limit!
NoChangeFrDirectionDown:
	jmp	ContinueFreq
DecreaseFreq:
	dec	NOISE_FREQ
	lda	NOISE_FREQ
	cmp	FREQ_LIMIT		;Maximum frequency
	bne	NoChangeFrDirectionUp	;Branch if still nonzero
	lda	#$00
	sta	FREQ_DIRECTION		;Start going up now
NoChangeFrDirectionUp:
ContinueFreq:
	lda	NOISE_FREQ
	and	#$0F
	sta	NOISE_FREQ
	sta	$400E
NoChangeFreq:
	dec	FREQ_COUNTDOWN

	rts

;.....................................................

Cycle_Colours:
	lda	VBCOUNT
	and	#$0F
	bne	NoCycleNeon
	lda	#$3F
	sta	$2006
	lda	#$15		;Point to the sprite PAL!
	sta	$2006
	ldx	NEON_POS
	lda	neon_table,X
	sta	$2007
	inx
	txa
	and	#$1F		;We have a simple 32 entries...
	tax
	lda	neon_table,X
	sta	$2007
	inx
	txa
	and	#$1F
	tax
	lda	neon_table,X
	sta	$2007
	inc	NEON_POS
	lda	NEON_POS
	and	#$1F
	sta	NEON_POS
NoCycleNeon:

	lda	VBCOUNT
	and	#$03
	bne	NoFlashCursor
	lda	#$3F
	sta	$2006
	lda	#$13
	sta	$2006		;Point to cursor palette
	lda	CURSOR_LIGHT
	eor	#$10
	sta	CURSOR_LIGHT	;Flash $16 or $06
	sta	$2007
NoFlashCursor:
	rts

neon_table:	.byte $06,$16,$26,$07,$17,$27,$08,$18,$28	;,$09,$19,$29
		.byte $1A,$2A,$0B,$1B,$2B,$0C,$1C,$2C,$01,$11,$21
		.byte $02,$12,$22,$03,$13,$23,$04,$14,$24,$05,$15,$25
;=====================================================================
;=====================================================================
UpdateScroller:
	inc	SCROLLERPOS
	lda	SCROLLERPOS
	cmp	#$08		;Is it time to swap sprites?
	bne	NoSwapSprites
	
	ldx	SCROLLERLIN
	ldy	#$08
swaploop:
	lda	SCROLL_SPR,X	;Reset Y-position
	clc
	adc	#$18
	sta	SCROLL_SPR,X
	inx
	lda	SCROLL_SPR,X
	clc
	adc	#$30
	jsr	DetectChrWrap
	sta	SCROLL_SPR,X	;Increase CHR-position
	inx
	inx
	inx
	dey
	bne	swaploop

	lda	#$00
	sta	SCROLLERPOS
	lda	SCROLLERLIN
	clc
	adc	#$20
	cmp	#$60
	bne	noresetscrolllin
	lda	#$00		;This should work?
noresetscrolllin:
	sta	SCROLLERLIN
	
NoSwapSprites:

	ldx	#$00
scrolloop:
	dec	SCROLL_SPR,X
	inx
	inx
	inx
	inx
	cpx	#$60
	bne	scrolloop
	rts

DetectChrWrap:
	pha
	and	#$F0
	cmp	#$00
	beq	NextChrTest	;Detect if our CHR pointer
	cmp	#$10		;is out of bounds
	beq	NextChrTest
	cmp	#$20
	beq	NextChrTest
	jmp	NoCHRWrapTest
NextChrTest:
	pla
;	and	#$0F		;This should swap & reset it!?
	eor	#$08
	ora	#$40
	pha
NoCHRWrapTest:
	pla
	rts

Update_Sprites:
	lda	ACTION_FLAG
	eor	#$01
	sta	ACTION_FLAG

	ldx	CURSOR_POS
	lda	cursor_x_tbl,X		
	sta	CURS_SPRX		

	lda	CURSOR_POS	;Change the Y-value and flipping
	and	#$08
	beq	First_Row_Sprite
	ldy	#$74		;Move to 2nd row, flip vertically
	lda	#$80
	jmp	WriteCursY
First_Row_Sprite:
	ldy	#$69		;1st row, no flipping.
	lda	#$00
WriteCursY:
	sty	CURS_SPRY
	sta	CURS_SPRFlip

;++++++++++++++++++++++++++++++++++++++++
;--------------- put in the code letters! ----------

	ldx	#$00
	ldy	#$00

put_letters:
	lda	code,Y		;Get one byte
	lsr
	lsr
	lsr
	lsr
	ora	#$10		;reduce to a digit
	sta	LETTER_TILES,X	;save in SPR-RAM
	inx
	inx
	inx
	inx			
	lda	code,Y
	and	#$0F		;get other nybble
	ora	#$10
	sta	LETTER_TILES,X
	inx
	inx
	inx
	inx
	iny			;do this 7 more times....
	cpy	#$08
	bne	put_letters

	rts

cursor_x_tbl:	.byte $21,$29,$31,$39,$41,$49,$51,$59
		.byte $41,$49,$51,$59,$91,$99,$C9,$D1

;****************************************************************

ControllerAction:
	lda	CONT1STROBE
	and	#%00000001	;Check "RIGHT"
	beq	NotContRight
	lda	CURSOR_POS
	clc
	adc	#$01
	and	#$07		;Restrict it
	sta	$00		;temp save it ;)
	lda	CURSOR_POS
	and	#$08
	ora	$00
	sta	CURSOR_POS	;Save it back.
	lda	#$01
	sta	ACTION_FLAG

NotContRight:
	lda	CONT1STROBE
	and	#%00000010	;Check "LEFT"
	beq	NotContLeft

	lda	CURSOR_POS
	sec
	sbc	#$01
	and	#$07		;Restrict it
	sta	$00		;temp save it ;)
	lda	CURSOR_POS
	and	#$08
	ora	$00
	sta	CURSOR_POS	;Save it back.
	lda	#$01
	sta	ACTION_FLAG

NotContLeft:
	lda	CONT1STROBE
	and	#%00000100	;Check "DOWN"
	beq	NotContDown

	lda	CURSOR_POS
	ora	#$08		;Ensure it is in the 2nd row!
	sta	CURSOR_POS
	lda	#$01
	sta	ACTION_FLAG

NotContDown:
	lda	CONT1STROBE
	and	#%00001000	;Check "UP"
	beq	NotContUp

	lda	CURSOR_POS
	and	#%11110111	;Ensure it is in the 1st row!
	sta	CURSOR_POS
	lda	#$01
	sta	ACTION_FLAG

NotContUp:
	lda	CONT1STROBE
	and	#%00010000	;Check "START"
	beq	NotContStart
NotContStart:
	lda	CONT1STROBE
	and	#%00100000	;Check "SELECT"
	beq	NotContSelect
NotContSelect:
	lda	CONT1STROBE
	and	#%01000000	;Check "B"
	beq	NotContB
	jsr	DecCodeBytes
NotContB:
	lda	CONT1STROBE
	and	#%10000000	;Check "A"
	beq	NotContA
	jsr	IncCodeBytes
NotContA:

noaction:
	rts
;..........................................
DecCodeBytes:
	lda	CURSOR_POS	;the cursor position determines the nybble
	and	#$01		;check if odd or even
	beq	deccodeeven
	lda	#$0F		;it's odd, so decrease by "1"!
	sta	$00		;temporary?
	jmp	contcodebytes
deccodeeven:
	lda	#$F0		;it's even, so decrease by "16"!
	sta	$00		;temporary?
	jmp	contcodebytes
IncCodeBytes:
	lda	CURSOR_POS
	and	#$01		;check if odd or even
	beq	inccodeeven
	lda	#$01		;it's odd, so increase by "1"!
	sta	$00		;temporary?
	jmp	contcodebytes
inccodeeven:
	lda	#$10		;it's even, so increase by "16"!
	sta	$00		;temporary?
	jmp	contcodebytes
contcodebytes:

	lda	CURSOR_POS
	lsr			;we don't need the low bit
	tax
	lda	code_ram_positions,X
	tax			;THIS goes to X!
	lda	code,X		;code or val or comp or addr
	and	#$F0
	sta	$02		;damn, I have to split it...
	lda	code,X		;code or val or comp or addr
	clc
	adc	$00		;this adds (or decs) the data
	and	#$0F		
	sta	$03		;The low half's done
	lda	$00
	and	#$F0
	clc
	adc	$02
	ora	$03		;Combines them?
	sta	code,X

	lda	CURSOR_POS
	and	#$08		;check if encoding or decoding???
	beq	set_decode_bit
	lda	#%00000101	;We'll encode, hopefully???
	sta	ACTION_FLAG
	lda	addr+1
	ora	#$80		;Make it only $8000-$FFFF!
	sta	addr+1
	jmp	DecEncEnd
set_decode_bit:
	lda	#%00000011	;We'll decode, hopefully???
	sta	ACTION_FLAG
DecEncEnd:
	rts

code_ram_positions: .byte $00,$01,$02,$03,$07,$06,$05,$04

;************************************************************
;************************************************************

Check_Controller:
	lda	CONTROLLER1		;the new becomes the old
	sta	CONT1LAST


checkcont1:	ldx	#$01
	stx	$4016
	dex
	stx	$4016			;Strobe controller.
	lda	$4016
	and	#$01			;Get A
	sta	CONTROLLER1
	lda	$4016
	lsr	A			;Get another bit
	rol	CONTROLLER1		;Get B
	lda	$4016
	lsr	A			;Get another bit
	rol	CONTROLLER1		;Get SELECT
	lda	$4016
	lsr	A			;Get another bit
	rol	CONTROLLER1		;Get START
	lda	$4016
	lsr	A			;Get another bit
	rol	CONTROLLER1		;Get UP
	lda	$4016
	lsr	A			;Get another bit
	rol	CONTROLLER1		;Get DOWN
	lda	$4016
	lsr	A			;Get another bit
	rol	CONTROLLER1		;Get LEFT
	lda	$4016
	lsr	A			;Get another bit
	rol	CONTROLLER1		;Get RIGHT
;
	lda	CONT1LAST
	eor	#$FF
	and	CONTROLLER1
	sta	CONT1STROBE		;Save strobe.

	rts

Setup_PPU:

	lda	#$20
	sta	$2006
	lda	#$00
	sta	$2006		;Point to NAM table

	lda	#<screentbl	;Get name data
	sta	$00
	lda	#>screentbl
	sta	$01
	ldx	#$04		;$0400 bytes
	ldy	#$00
DrawNAM:
	lda	($00),Y
	sta	$2007
	iny
	bne	DrawNAM
	inc	$01
	dex
	bne	DrawNAM

	lda	#$3F
	sta	$2006
	lda	#$00
	sta	$2006		;Point to PALETTE table

	ldx	#$00
WritePal:
	lda	Rocky_Palette,X
	sta	$2007
	inx
	cpx	#$20
	bne	WritePal

	rts

Rocky_Palette:	.byte	$0F,$2D,$10,$30,$0F,$19,$29,$39
		.byte   $0F,$17,$29,$15,$0F,$16,$27,$38
		.byte   $0F,$30,$30,$16,$0F,$06,$16,$26
		.byte   $0F,$08,$00,$38,$0F,$1B,$00,$12
;=============================================================
;-------------------------------------------------------------

Wait_1_VB:
	pha
vbA:	lda	$2002		;Wait for VBlank to end
	bmi	vbA
vbB:	lda	$2002		;Wait for VBlank to start
	bpl	vbB
	pla
	rts


FDS_HOOK:		;Sets up the program to run fine on the FDS.
	pha
	lda	#$C0
	sta	$0100
	lda	#$80
	sta	$0101
	lda	#$35
	sta	$0102
	lda	#$53
	sta	$0103
	pla
	rts
;

Init_Clear_PPU:
	lda	#$20
	sta	$2006
	lda	#$00
	sta	$2006

	ldy	#$0B
	sty	$0001
	ldy	#$00
	sty	$0000
	lda	#$00

cppu1:	sta	$2007	;Clear 2 PPU NAM tables
	dey
	bne	cppu1
	dec	$0001
	bpl	cppu1

	lda	#$23		;Point to attribute table
	sta	$2006
	lda	#$C0
	sta	$2006

	ldy	#$40
	lda	#$00		;This gives me the pattern I want.
att_loop:	sta	$2007
	dey
	bne	att_loop

	ldx	#$00
copyspr:
	lda	sprtbl,X	;Copy sprites to RAM
	sta	SPR_RAM,X
	inx
	bne	copyspr

	rts

screentbl:	.incbin "rocky.nam"
		.incbin "rocky.att"

sprtbl:		.incbin "sprites.bin"
;---------------------------------------------
;



.segment "VECTORS"
;.word NMI_SUB, Reset_SUB, IRQ_SUB

;	.word NMI_SUB
;	.word NMI_SUB
	.word NMI_SUB
	.word Reset_SUB
	.word IRQ_SUB
.end