; Program to play around with graphics artifacts
;
;
;

        .include "INC\My_startup.asm"
	.nomlist
	.list
; ----

SATB_VRAM:	.equ	$4300		;So background tiles can go up to $42FF! (32256 bytes?)
				;Or with a 512x256 BG, 30208 bytes.
SPRIT_VRAM:	.equ	$4400
PALS_BANK:	.equ	START_BANK+1	;All BG palettes should fit into 1 bank (16 pic palettes!)
GFX_BANK:	.equ    START_BANK+2
SMP_BANK:	.equ    START_BANK+$3D

TIA_RAM:	.equ	$2110
TIA_DEST:	.equ    TIA_RAM+2

TYP_NORM:	.equ	0	;VRAM writing / expansion types
TYP_DBL:	.equ	1
TYP_DITH:	.equ	2
TYP_BAT:	.equ	3
TYP_FILL:	.equ	4	;Fill with 2 bytes in (src)

TITLEPIC_DELAY:	.equ	250
GEOFF_PIC_DELAY .equ	320
PIC_DELAY:	.equ	190
FASTFAST equ 0

; Zero-page variables

	.zp
fails:		ds 2
nmi_count: 	ds 1	;Counter for NMIs...
VCE_copy:  	ds 1
bgspron:	ds 1	;Turn on/off BG/Spr
scanline:	ds 2
BorderCol:	ds 2	;Border colour setting
;----
mstr_scan_size:	ds 1
scan_size:	ds 1
scan_ctr:	ds 1
scan_scroll:	ds 2	;per-scanline scroll!
;-----
sx:		ds 2
sy:		ds 2
sprite_no: 	ds 1
spr_vram_point: ds 2
scroll_x: 	ds 2
scroll_y: 	ds 2
HiC_Pos:	ds 1
;------------------------------------------------
pic_enum:	ds 1	;0,1,2,3... Pic number in order
picno:		ds 1	;sorted list of my pictures!
sub_picno:	ds 1	;a list of auxiliary pictures
stepno:		ds 1	;Maybe 0 = no actions
textstepno:	ds 1	;What step are we on for Text animation?
;---------------------------- sprite palette stuff
paletteno: 	ds 1
cycle_on:	ds 1	;1= on, of course!
cyclepos:	ds 1	;2,4,6...30	(pointer to palette entry)
fade_on:	ds 1	;A Fading flag!
picdelay:	ds 2	;countdown timer for picture change
warp_on:	ds 1	;A flag to warp the screen.  Bit 7=on, bit 0= MOSAIC/SCROLL
pause:		ds 1	;Pause the auto-timer
scr_width:	ds 1	;Width variable for screen
;----------------------
FadeVol:	ds 1	;Volume setting
FadeVolOut:	ds 1	;Trigger to fade
;------------------
sample:  	ds 1
sndbuf0: 	ds 1
sndbuf1: 	ds 1
sampadd:	ds 2
samp_on:	ds 1
song_pos:	ds 1	;position in sample list
song_loop:	ds 1	;loop counter for each sample
Sequence:	ds 2	;address for current sequence
seq_counter:	ds 1
seq_loop:	ds 1
samp_interrupt: ds 1	;Don't recursively enter the sample player!
;-------
fill_vram:	ds 1	;flag to fill VRAM or not
vram_add:	ds 2	;VRAM write address
data_src:	ds 2	;source from ROM
data_src_bank:	ds 1	;Bank # for source
data_len:	ds 2	;WORD Length of source data.
data_type:	ds 1	;0=normal, 1=Dbl-Bits, 2=Dbl-Dither, 3=BAT expand
interrupted:	ds 1	;flag to signal bad VRAM write!



	.bss
satb		.ds 512	; the local SATB
	;...

;--- CODE area ----------

	.code
	.bank START_BANK

clear_vars:
	lda	#0		;This sets the SPRite overlay PAL!
	sta	<paletteno
	stz	<fill_vram	;Writing flag OFF!
	rmb0	<cycle_on       ;Cycling starts OFF
	rmb0	<fade_on	;FADING starts OFF!
	stz	<warp_on	;No warping, scrolling
	rmb0	<pause
	stz	<seq_counter
	stwz	<BorderCol
	stz	<samp_interrupt

	lda	#$22		;Fully faded in
;;	lda	#2
	sta	<cyclepos		;(pointer to palette entry)
	stz	<sub_picno		;clear sub picture counter
	lda	#0
	sta	<pic_enum		;clear main picture counter
	jsr	Assign_Pic_No
;;;;;;;;;;;;;x	sta	<picno
	lda	#1
	sta	<stepno

	stz	<mstr_scan_size
;;;	lda	Scan_Size_Tbl,X
	lda	#1
	sta	<scan_size

	tii	TIA_Pal,TIA_RAM,8	;Copy modifiable code over
	rts
;==============================================================================

main:
	jsr	clear_vars
	jsr	setup_video
	jsr	Init_Music_Sequencer
	jsr	setup_sound



	setvec #VSYNC,vsync_proc
	vec_on #VSYNC
	setvec #HSYNC,hsync_proc
	vec_on #HSYNC

	smb7	<samp_on	;Bit 7 UP means don't do anything!!!!
	rmb0	<samp_on	;sample player is OFF!

;	rmb7	<samp_on	;NOW start the sample engine
;	smb0	<samp_on        ;HSync player active


	SCREEN_OFF
;	SCREEN_ON
	;BG_ON


.here:
	bbs7	<samp_on,.no_sample_check	;if in fade-in, etc. don't play yet.
	bbs0	<samp_on,.fine_sample	;if sample finished, restart...?
	jsr	Music_Sequencer
.fine_sample:

	IF (1=1)
.pre_vb_loop:
	cmpw	#$41,<scanline
	bne	.not_pre_vb_loop
	jsr	Sample_Loop
	ldx	#$40
.fukdelay:
	dex
	bne	.fukdelay
	bra	.here		;if doing extra samples, skip VRAM write!!
.not_pre_vb_loop:
	ENDIF

.no_sample_check:

	bbr0	<fill_vram,.no_VRAM_update	;flag to fill VRAM ON?
	jsr	Squirt_VRAM			;really!  2 bytes at a time?
.no_VRAM_update:
	bra    .here

	;...

hsync_proc:
	incw	<scanline
	st0	#6	;Set raster interrupts!
	stw	<scanline,video_data

	jsr	Sample_Loop
;================ Y-Scroll Assfuckery =========
	bbr7	<warp_on,.no_warping
	dec	<scan_ctr
	bne	.no_change_yscroll_val

	stw	<scanline,<scan_scroll
	subw	#$42,<scan_scroll
	lda	<scan_size
	sta     <scan_ctr
.no_change_yscroll_val:
	st0	#8	;Clear scrolling?
	stw	<scan_scroll,video_data
.no_warping:
	st0	#1	;MEMORY READ REG!
;==================================



;	incw	<scroll_x
;	st0	#7	;Clear scrolling?
;	stw	<scroll_x,video_data

	smb0	<interrupted
	rts

vsync_proc:
	inc	<nmi_count
;;	jsr	Sample_Loop
	jsr	TestJoypad	;This changes the values and cursor

;	cmpw	#-32,<scroll_x
;	beq	.no_scroll
;	decw	<scroll_x

.no_scroll:
;	stw	#-32,<scroll_x

	st0	#7	;Clear scrolling?
	stw	<scroll_x,video_data
	st0	#8	;Clear scrolling?
	stw	<scroll_y,video_data

	stw	<scroll_y,<scan_scroll
	decw	<scan_scroll
	lda	<scan_size
	sta	<scan_ctr

	stw	#$40,<scanline
	st0	#6	;Set raster interrupts!
	stw	<scanline,video_data

	jsr	Check_Steps	;check if we need to go to the next pic
	jsr	Colour_Cycling
	jsr	Scroll_Warping
	jsr	Sound_Fade_Check

	smb0	<interrupted
	rts

;[ USER DATA ]

Check_Steps:	;Check each step in my demo
	bbs0	<fill_vram,.not_yet
	lda	<stepno
	beq	.not_yet	;nothing in step 0!
	asl	a
	bcs	.high_steps	;if <stepno is 128+
	tax
	jmp	[Step_Tbl,X]
.high_steps	;if <stepno is 128+
	tax
	jmp	[Step_Tbl+256,X]
.not_yet:
	rts

TestJoypad:
	tst	#$01,joytrg	;This is I
	beq	.NoPushButI

	lda	<pause
	eor	#1
	sta	<pause
.NoPushButI:

	tst	#$02,joytrg	;This is II
	beq	.NoPushButII
	jsr	yres_up
.NoPushButII:
	rts

;	tst	#$08,joytrg	;This is Run?
;	beq	.NoPushButRun
;	lda	<bgspron
;	eor	#$40		;toggle SPR!
;	sta     <bgspron
;	jmp	Set_BG_SPR
;.NoPushButRun:
;	rts










;=======================================================================

;***************************************************


setup_video:
;;	SCREEN_OFF
	init_satb satb
	jsr	Setup_Sprites
	jsr	xres_320
	jsr	yres_240
	jsr	BAT_6432


;	jsr	pick_pic_pal
;	jsr	pick_sprite_pal

	stw	#0,<scroll_x
	stw	#0,<scroll_y

	jsr	Update_Satb_BLOCKTRANSFER

	stw	#$240,<scanline
	st0	#6	;Set raster interrupts!
	stw	<scanline,video_data


	st0	#7	;Clear scrolling?
	stw	<scroll_x,video_data
	st0	#8	;Clear scrolling?
	stw	<scroll_y,video_data
	rts







;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@







;External Routines at the end of this bank!!!
	.include "INC\demo_steps.asm"	;Sequence of commands to make a slideshow
	.include "INC\gfx_stuff.asm"	;Basic graphics routines
	.include "INC\sprite_stuff.asm"	;Sprite drawing routines
	.include "INC\sound.asm"	;Sample player!
	.include "INC\music.asm"	;Sequencer & Sample INCBINs!

;**************************************************

	.include "GFX\gfx_banks.asm"

;	.bank $7F	;Set the final size of my ROM!
;	.db $FF