;ummm.... NTSC is 15734 samples per second
;sample needs to be ~28672 bytes long
; (half is 14336 bytes)

; CS #33 is 26965 or so samples

Sample_Loop:
	bbs0	<samp_interrupt,.no_sample_play
	bbr0	<samp_on,.no_sample_play
;;	cla	;Start at 0
;;	sta	<sample
.samp_loop:
	smb0	<samp_interrupt		;Stop player from entering twice
	lda	[sampadd]	;<sample
	beq	.sample_end_marker
	tax
	lsr	a
	lsr	a
	lsr	a	;divide by 8!
	sax	;;;	sta	<sndbuf0
		;	lda	<sample
	and	#$07	;top 3 bits
	ldy	#3
	sty	$0800   ;chan 3
	sta	$0806	;Save sample!!
	dey
	sty	$0800   ;chan 2
	sta	$0806	;Save sample!!
	dey
	sty	$0800   ;chan 1
	stx	$0806	;Save sample!!
	stz	$0800
	stx	$0806	;Save sample!!
	incw	<sampadd
	rmb0	<samp_interrupt		;Stop player from entering twice

.no_sample_play:
	rts
.sample_end_marker:
	rmb0	<samp_on	;no more samples!
	rmb0	<samp_interrupt		;Stop player from entering twice
	rts

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
setup_sound:
	cly
	clx	;Square wave
	jsr	setup_sound_regs	;0
	ldy	#1
	clx	;Square wave
	jsr	setup_sound_regs	;1
	ldy	#2
	clx	;Square wave
	jsr	setup_sound_regs	;2
	ldy	#3
	clx
	jsr	setup_sound_regs	;3
	ldy	#4
	clx
	jsr	setup_sound_regs	;4
	ldy	#5
	clx
	jsr	setup_sound_regs	;5

	lda	#$FF
	sta	$0801				;Master Volume
	sta	<FadeVol
	stz	<FadeVolOut	;Don't fade!


	stz	$0800		;Choose channel 0
	lda	#$FF
	sta	$0805		;Panning max
	lda	#$C0+$1F	;DDA ON!
	sta	$0804		;Write PCE Volume
;====================================================
	lda	#$02
	sta	$0800		;Choose channel 2
	lda	#$99		;#$99 gives 8-bit precision!
	sta	$0805		;Panning
	lda	#$C0+$1F        ;DDA ON!
	sta	$0804		;Write PCE Volume
;----
	lda	#$01
	sta	$0800		;Choose channel 1
	lda	#$FF
	sta	$0805		;Panning max
	lda	#$C0+$1F	;DDA ON!
	sta	$0804		;Write PCE Volume
;====================================================
	lda	#$03
	sta	$0800		;Choose channel 3
	lda	#$99		;#$99 gives 8-bit precision!
	sta	$0805		;Panning
	lda	#$C0+$1F        ;DDA ON!
	sta	$0804		;Write PCE Volume

	rts


Sound_Fade_Check:	;Fade out volume of our song!
	bbr0	<FadeVolOut,.do_nothing
	lda	<nmi_count
	and	#$0F
	bne     .do_nothing
	lda	<FadeVol
	beq     .do_nothing	;If volume 0, finished!
	sub	#$11
	sta	<FadeVol
	sta	$0801		;Write new volume
.do_nothing:

	rts



setup_sound_regs:	;Inputs: Y-channel #, X-waveform

	sty	$0800		;Choose channel 0
	lda	#%01000000	;reset the waveform write pointer
	sta	$0804
	lda	#%00000000
	sta	$0804

	cly
load:   lda     wave_tables,x  ; Load a sample in A
	sta     $0806   ; Write the sample
	inx             ; Increment the table index
	iny
	cpy     #32     ; Have we reached the end?
	bne     load    ; If no continue

	stw	#$0001,$0802		;Silence the frequency
	;lda	#$FF
	cla
	sta	$0805				;Equal Balance.
	sta	$0801				;Master Volume
	lda	#$00
	eor	#$00			;We do this by ORing with the volume.
	sta	$0804



	rts
;-----------------------------------------------
wave_tables:
wave_silence:	db $f,$f,$f,$f,$f,$f,$f,$f
		db $f,$f,$f,$f,$f,$f,$f,$f
		db $f,$f,$f,$f,$f,$f,$f,$f
		db $f,$f,$f,$f,$f,$f,$f,$f
;
;wave_square0: db 31,31,31,31,0,0,0,0,0,0,0,0,0,0,0,0
;	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;wave_square1: db 30,30,30,30,30,30,30,30,0,0,0,0,0,0,0,0
;	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;wave_square2: db 28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28
;	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;wave_square3: db 30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30
;	db 30,30,30,30,30,30,30,30,0,0,0,0,0,0,0,0
;wave_triangle: db 0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30
;	db 31,29,27,25,23,21,19,17,15,13,11,9,7,5,3,1
;wave_sine:   db      18,22,24,26,28,28,30,30
;	db      30,30,28,28,26,24,22,18
;	db      12,8,6,4,2,2,0,0
;	db      0,0,2,2,4,6,8,12
;wave_saw:	db	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
;	db	16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31