; Here is the sample sequencer for music!

;MACROS!

Loop1ab_MAC	.macro
 .db		M_Sam1a,1
 .db            M_Sam1b,1
		.endm

Loop1ad_MAC	.macro
 .db		M_Sam1a,1
 .db            M_Sam1d,1
		.endm

Loop2ab_MAC	.macro
 .db		M_Sam2a1,1
 .db		M_Sam2a2,1
 .db            M_Sam2b,1
		.endm

Loop2ad_MAC	.macro
 .db		M_Sam2a1,1
 .db		M_Sam2a2,1
 .db            M_Sam2d,1
		.endm

Loop3ab_MAC	.macro
 .db		M_Sam3a1,1
 .db		M_Sam3a2,1
 .db            M_Sam2b,1
		.endm

Loop4ab_MAC	.macro
 .db		M_Sam4a,1
 .db            M_Sam4b,1
		.endm

Loop4bb_MAC	.macro
 .db		M_Sam4b,2
		.endm

Loop4aa_MAC	.macro
 .db		M_Sam4a,2
		.endm

Loop5ab_MAC	.macro
 .db		M_Sam5a,1
 .db            M_Sam5b,1
		.endm

Loop5ad_MAC	.macro
 .db		M_Sam5a,1
 .db            M_Sam5d,1
		.endm

Loop6_MAC	.macro
 .db		M_Sam6a,1
 .db            M_Sam6b,1
 .db            M_Sam6c,1
		.endm

Loop7a_MAC	.macro
 .db		M_Sam7a1,1
 .db            M_Sam7a2,1
		.endm

Loop7d_MAC	.macro
 .db		M_Sam7d1,1
 .db            M_Sam7d2,1
		.endm

Loop7g_MAC	.macro
 .db		M_Sam7g1,1
 .db            M_Sam7g2,1
		.endm

Loop7h_MAC	.macro
 .db		M_Sam7h1,1
 .db            M_Sam7h2,1
		.endm

Loop8_MAC	.macro
 .db		M_Sam8a,1
 .db            M_Sam8b1,1
 .db		M_Sam8a,1
 .db            M_Sam8b1,1
; .db            M_Sam8b2,1
 .db		M_Sam8a,1
 .db            M_Sam8b1,1
 .db            M_Sam8b1,1
 .db		M_Sam8a,1
 .db            M_Sam8c,4
		.endm

;Warble_MAC	.macro
; .db		M_Warble	,	8	;8 loops of warbling
;		.endm

;SeqA_MAC	.macro
; .db		M_A1            ,	1
; .db		M_A2		,	1
; .db		M_A1            ,	1
; .db		M_A2		,	1
;		.endm

;SeqB_MAC	.macro
; .db		M_B1            ,	1
; .db		M_B2		,	3
;		.endm



;Sample "names"
M_Sam1a	= 0	;Loop 1, first 1/2
M_Sam1b	= 1	;2nd 1/2, normally
M_Sam1d	= 2     ;2nd 1/2, on 4th time
M_Sam2a1 = 3	;Loop 1, first 1/2
M_Sam2a2 = 4
M_Sam2b	= 5	;2nd 1/2, normally
M_Sam2d	= 6     ;2nd 1/2, on 4th time
M_Sam3a1 = 7	;Cymbal Hit, ends with sample 2?
M_Sam3a2 = 8	;Cymbal Hit, ends with sample 2?
M_Sam4a	= 9	;Cymbal Hit With crashing
M_Sam4b	= 10	;Cymbal Hit, more crashing

M_Sam5a	= 11	;First hardcore techno loop, 1/4
M_Sam5b	= 12	;2-4/4
M_Sam5d	= 13    ;2-4/4 Crash Hits

M_Sam6a	= 14	;mellow warbling
M_Sam6b	= 15	;
M_Sam6c	= 16    ;

M_Sam7a1 = 17	;Hardcore acid crescendo, broken up into sections
M_Sam7a2 = M_Sam7a1 + 1
M_Sam7d1 = M_Sam7a1 + 2
M_Sam7d2 = M_Sam7a1 + 3
M_Sam7g1 = M_Sam7a1 + 4
M_Sam7g2 = M_Sam7a1 + 5
M_Sam7h1 = M_Sam7a1 + 6
M_Sam7h2 = M_Sam7a1 + 7

M_Sam8a	 = M_Sam7a1 + 8
M_Sam8b1 = M_Sam7a1 + 9
M_Sam8b2 = M_Sam7a1 + 10
M_Sam8c  = M_Sam7a1 + 11

Song_Seq: 	;The master list of music sequences to play, plus their loops

	.dw Loop1_Full
	.db 2
	.dw Loop2_Full
	.db 2
	.dw Loop3_Full
	.db 3

	.dw Loop3_Half
	.db 1
	;drum roll NEEDED HERE!
	.dw Loop34_Full
	.db 1

	.dw Loop5_Full
	.db 4
;	.dw Loop6_Full
;	.db 12

	;is this drum roll OK here?
	.dw Loop34_Full
	.db 1

	.dw Loop7_First
	.db 4
	.dw Loop6_Full
	.db 8
	.dw Loop8_Full	;This is a triple-hit
	.db 1
	.dw Loop7_Full
	.db 1
	.dw Loop7_MixupA
	.db 1
	.dw Loop7_MixupB
	.db 1
	.dw Loop6_Full
	.db 16
	.dw Loop8_Full	;This is a triple-hit
	.db 1


;	.dw Loop7_First
;	.db 3
;	.dw Loop7_Last
;	.db 1
;------------ finish / reloop
		;;.dw -1	;FADE OUT
	.dw 0


Loop1_Full:
	Loop1ab_MAC
	Loop1ab_MAC
	Loop1ab_MAC
	Loop1ad_MAC
	.db -1
Loop2_Full:
	Loop2ab_MAC
	Loop2ab_MAC
	Loop2ab_MAC
	Loop2ad_MAC
	.db -1
Loop3_Full:
	Loop3ab_MAC
	Loop3ab_MAC
	.db -1
Loop3_Half:
	Loop3ab_MAC
	.db -1
Loop34_Full:
	Loop4ab_MAC
	Loop4ab_MAC
	.db -1
Loop5_Full:
	Loop5ab_MAC
	Loop5ab_MAC
	Loop5ab_MAC
	Loop5ad_MAC
	.db -1

Loop6_Full:
	Loop6_MAC
;	Loop5ab_MAC
;	Loop5ab_MAC
;	Loop5ad_MAC
	.db -1

Loop7_First:
	Loop7a_MAC
	Loop7a_MAC
	Loop7a_MAC
	Loop7d_MAC
	.db -1
Loop7_Last:
	Loop7a_MAC
	Loop7a_MAC
	Loop7g_MAC
	Loop7h_MAC
	.db -1

Loop7_Full:
	Loop7a_MAC
	Loop7a_MAC
	Loop7a_MAC
	Loop7d_MAC
	Loop7a_MAC
	Loop7a_MAC
	Loop7a_MAC
	Loop7d_MAC
	Loop7a_MAC
	Loop7a_MAC
	Loop7a_MAC
	Loop7d_MAC
	Loop7a_MAC
	Loop7a_MAC
	Loop7g_MAC
	Loop7h_MAC
	.db -1

Loop7_MixupA:
	Loop7d_MAC
	Loop7d_MAC
	Loop7a_MAC
	Loop7a_MAC
	.db -1
Loop7_MixupB:
	Loop7d_MAC
	Loop7d_MAC
	Loop7g_MAC
	Loop7h_MAC
	.db -1

Loop8_Full:
	Loop8_MAC	;This is a triple-hit
	.db -1



 .db		-1				;END!


;==============================
Music_Sequencer:	;This is called when a sample has FINISHED!
	dec	<song_loop	;Check loop counter
	bne	.reloop_sample	;If not zero yet, loop the same sample

	;here the loop is down to Zero, so re-load music sequence, re-map sample
	inc	<song_pos
	inc	<song_pos
	jsr	Remap_Sample
	smb0	<samp_on	;sample player is ON!
	rts
.reloop_sample:
	jsr	Point_to_Sample
	smb0	<samp_on	;sample player is ON!
	rts

Fade_Loop_Sequence:
	smb0	<FadeVolOut	;Fade out at end!!!
Loop_Song_Sequence:
	lda	#-3
	sta     <seq_counter
	lda	#1
	sta     <seq_loop
Next_Song_Sequence:
	dec	<seq_loop	;Decrease loop counter
	bne	.no_next_song
	inc	<seq_counter
	inc	<seq_counter
	inc     <seq_counter
	ldx	<seq_counter
        lda	Song_Seq+2,X	;Get loop counter
	sta     <seq_loop
.no_next_song:
	ldx	<seq_counter
        lda	Song_Seq+1,X	;Get HI address of next sequence
	beq	Loop_Song_Sequence	;if Zero, reloop
	cmp	#$FF                    ;if $FFxx, fade out?
	beq	Fade_Loop_Sequence
	sta     <Sequence+1
	lda	Song_Seq,X	;Get LO address of next sequence
	beq	Loop_Song_Sequence	;if Zero, reloop
	sta     <Sequence
	rts


Init_Music_Sequencer:
	jsr	Loop_Song_Sequence	;;stw	#Music_Sequence,<Sequence
	bra	_resmus
Restart_Music_Pos:
	jsr	Next_Song_Sequence
_resmus:
	stz	<song_pos
Remap_Sample:
	ldy	<song_pos
	iny
	lda     [Sequence],Y	;get loops first
	dey
	sta	<song_loop		;loop counter

	lda	[Sequence],Y	;get Sample entry!
	cmp	#$FF                    ;is it "END"?
	beq	Restart_Music_Pos       ;restart if so
	tax
	lda     Samps_Bank,X		;get bank of 1st entry
	tam #3
	inc 	a
	tam #4
	inc 	a
	tam #5
	inc 	a
	tam #6
; drop down to next subroutine!

Point_to_Sample:
	ldy	<song_pos
;	asl	a
;	tax
	lda	[Sequence],Y	;get Sample entry!
	asl	a
	tax
	lda	Samps_Add,X	;Get low byte of address start
	sta	<sampadd
	lda	Samps_Add+1,X	;Get high byte
	and	#$1F		;isolate to $0000-$1FFF
	ora	#$60		;start at $6000-up!
	sta     <sampadd+1

	rts


;==============================


Samps_Add:
	.dw Samp1a,Samp1b,Samp1d
	.dw Samp2a1,Samp2a2,Samp2b,Samp2d
	.dw Samp3a1,Samp3a2
	.dw Samp4a,Samp4b
	.dw Samp5a,Samp5b,Samp5d
	.dw Samp6a,Samp6b,Samp6c
        .dw Samp7a1,Samp7a2,Samp7d1,Samp7d2
        .dw Samp7g1,Samp7g2,Samp7h1,Samp7h2
	.dw Samp8a,Samp8b1,Samp8b2,Samp8c

Samps_Bank:
	.db BANK(Samp1a),BANK(Samp1b),BANK(Samp1d)
	.db BANK(Samp2a1),BANK(Samp2a2),BANK(Samp2b),BANK(Samp2d)
	.db BANK(Samp3a1),BANK(Samp3a2)
	.db BANK(Samp4a),BANK(Samp4b)
	.db BANK(Samp5a),BANK(Samp5b),BANK(Samp5d)
	.db BANK(Samp6a),BANK(Samp6b),BANK(Samp6c)
	.db BANK(Samp7a1),BANK(Samp7a2),BANK(Samp7d1),BANK(Samp7d2)
	.db BANK(Samp7g1),BANK(Samp7g2),BANK(Samp7h1),BANK(Samp7h2)
	.db BANK(Samp8a),BANK(Samp8b1),BANK(Samp8b2),BANK(Samp8c)

;Sample definitions below!!
; CS #33 is 26965 or so samples


	.bank SMP_BANK
	.org	$6000
Samp1a:
	.incbin "SMP\Era-1a.bin"
	.db 0
Samp1b:
	.incbin "SMP\Era-1b.bin"
	.db 0
Samp1d:
	.incbin "SMP\Era-1d.bin"
	.db 0
Samp2a1:
;;;	.incbin "SMP\Era-2a.bin"
	.incbin "SMP\Era-2a1.bin"
	.db 0
Samp2a2:
	.incbin "SMP\Era-2a2.bin"
	.db 0
Samp2b:
Samp2d:		;This will use the same sample, maybe!
	.incbin "SMP\Era-2b.bin"
	.db 0
;;;Samp2d:
;;;	.incbin "SMP\Era-2d.bin"
;;;	.db 0

Samp3a1:
	.incbin "SMP\Era-3a1.bin"
	.db 0
Samp3a2:
	.incbin "SMP\Era-3a2.bin"
	.db 0

Samp4a:
;;	.incbin "SMP\Era-4a.bin"
;;	.db 0
Samp4b:
	.incbin "SMP\Era-4b.bin"
	.db 0

Samp5a:
	.incbin "SMP\Era-5a.bin"
	.db 0
Samp5b:
	.incbin "SMP\Era-5b.bin"
	.db 0
Samp5d:
	.incbin "SMP\Era-5d.bin"
	.db 0

Samp7a1:
	.incbin "SMP\Era-7a1.bin"
	.db 0
Samp7a2:
	.incbin "SMP\Era-7a2.bin"
	.db 0
Samp7d1:
	.incbin "SMP\Era-7d1.bin"
	.db 0
Samp7d2:
	.incbin "SMP\Era-7d2.bin"
	.db 0
Samp7g1:
	.incbin "SMP\Era-7g1.bin"
	.db 0
Samp7g2:
	.incbin "SMP\Era-7g2.bin"
	.db 0
Samp7h1:
	.incbin "SMP\Era-7h1.bin"
	.db 0
Samp7h2:
	.incbin "SMP\Era-7h2.bin"
	.db 0

Samp6a:
	.incbin "SMP\Era-6a.bin"
	.db 0
Samp6b:
	.incbin "SMP\Era-6b.bin"
	.db 0
Samp6c:
	.incbin "SMP\Era-6c.bin"
	.db 0

Samp8a:
	.incbin "SMP\Era-8a.bin"
	.db 0
Samp8b1:
Samp8b2:
	.incbin "SMP\Era-8b1.bin"
	.db 0
;;;	.incbin "SMP\Era-8b2.bin"
;;;	.db 0
Samp8c:
	.incbin "SMP\Era-8c2.bin"
	.db 0