; Here is the sample sequencer for music!

;MACROS!

Intro_MAC	.macro
 .db		M_Intro		,	8	;8 loops of intro
		.endm
Warble_MAC	.macro
 .db		M_Warble	,	8	;8 loops of warbling
		.endm

SeqA_MAC	.macro
 .db		M_A1            ,	1
 .db		M_A2		,	1
 .db		M_A1            ,	1
 .db		M_A2		,	1
		.endm

SeqB_MAC	.macro
 .db		M_B1            ,	1
 .db		M_B2		,	3
		.endm



;Sample "names"
M_Intro	= 0	;Introduction
M_A1	= 1	;Bwaw wow wow 1st half
M_A2	= 2     ;Bwaw wow wow 2nd half
M_Warble = 3
M_B1	= 4	;wow wow wow 1st half
M_B2	= 5     ;wow wow wow 2nd half

Song_Seq: 	;The master list of music sequences to play, plus their loops
	.dw Music_Sequence
	.db 1
	.dw Music_Sequence2
	.db 16
;------------ finish / reloop
	.dw 0


Music_Sequence:
	Intro_MAC
	Warble_MAC
	SeqA_MAC
	SeqB_MAC
	.db -1

Music_Sequence2:
	SeqA_MAC

 .db		-1				;END!


;==============================
Music_Sequencer:	;This is called when a sample has FINISHED!
	dec	<song_loop	;Check loop counter
	bne	.reloop_sample	;If not zero yet, loop the same sample

	;here the loop is down to Zero, so re-load music sequence, re-map sample
	inc	<song_pos
	inc	<song_pos
	jsr	Remap_Sample
	smb0	<samp_on	;sample player is ON!
	rts
.reloop_sample:
	jsr	Point_to_Sample
	smb0	<samp_on	;sample player is ON!
	rts

Loop_Song_Sequence:
	lda	#-3
	sta     <seq_counter
	lda	#1
	sta     <seq_loop
Next_Song_Sequence:
	dec	<seq_loop	;Decrease loop counter
	bne	.no_next_song
	inc	<seq_counter
	inc	<seq_counter
	inc     <seq_counter
	ldx	<seq_counter
        lda	Song_Seq+2,X	;Get loop counter
	sta     <seq_loop
.no_next_song:
	ldx	<seq_counter
        lda	Song_Seq+1,X	;Get HI address of next sequence
	beq	Loop_Song_Sequence	;if Zero, reloop
	sta     <Sequence+1
	lda	Song_Seq,X	;Get LO address of next sequence
	beq	Loop_Song_Sequence	;if Zero, reloop
	sta     <Sequence
	rts


Init_Music_Sequencer:
	jsr	Loop_Song_Sequence	;;stw	#Music_Sequence,<Sequence
	bra	_resmus
Restart_Music_Pos:
	jsr	Next_Song_Sequence
_resmus:
	stz	<song_pos
Remap_Sample:
	ldy	<song_pos
	iny
	lda     [Sequence],Y	;get loops first
	dey
	sta	<song_loop		;loop counter

	lda	[Sequence],Y	;get Sample entry!
	cmp	#$FF                    ;is it "END"?
	beq	Restart_Music_Pos       ;restart if so
	tax
	lda     Samps_Bank,X		;get bank of 1st entry
	tam #3
	inc 	a
	tam #4
	inc 	a
	tam #5
	inc 	a
	tam #6
; drop down to next subroutine!

Point_to_Sample:
	ldy	<song_pos
;	asl	a
;	tax
	lda	[Sequence],Y	;get Sample entry!
	asl	a
	tax
	lda	Samps_Add,X	;Get low byte of address start
	sta	<sampadd
	lda	Samps_Add+1,X	;Get high byte
	and	#$1F		;isolate to $0000-$1FFF
	ora	#$60		;start at $6000-up!
	sta     <sampadd+1

	rts


;==============================


Samps_Add:
	.dw SecIntro,SecA1,SecA2,SecWarble,SecB1,SecB2
Samps_Bank:
	.db BANK(SecIntro),BANK(SecA1),BANK(SecA2),BANK(SecWarble),BANK(SecB1),BANK(SecB2)

;Sample definitions below!!

	.bank SMP_BANK
	.org	$6000
SecIntro:
;;	.incbin "SMP\square.bin"
	.incbin "SMP\Intro.bin"
	.db 0
SecWarble:
	.incbin "SMP\Warble.bin"
	.db 0
SecA1:
	.incbin "SMP\SecA1.bin"
	.db 0
SecB1:
	.incbin "SMP\SecB1.bin"
	.db 0

SecA2:		;Same as below!
;	.incbin "SMP\SecA2.bin"
;	.db 0
SecB2:
	.incbin "SMP\SecB2.bin"
	.db 0