Pic_Order:		.db 16,15,14,0,1,10,4,6,7,5,3,8,2,11,9,12,13,-1

Pic_BG_Size_List:       .dw 9344	;0 CMC 3 9488	;0 CMC Logo ;11792	;R-Type ;.dw 11120 ;CMC 2
			.dw 11008	;1 Mand Title	;8704	;1 Mandelbrot Title
			.dw 14528	;2 AZ1
			.dw 11280	;3 Shrine
			.dw 13072	;4 Shack
			.dw 12880	;5 City 3 ;13216	;City 2		;.dw 12208	;City
			.dw 9776	;6 Road
			.dw 12688	;7 Cloudy Sky
		 	.dw 12800	;8 Blossoms
			.dw 14000	;9 My Solar System	;14832	;Solar System
			.dw 10784	;10 Tut
			.dw 10032	;11 Tape Deck	;.dw 14400	;Cars
			.dw 12288	;12 Yoshiko
			.dw 13312	;13 Geoffrey	.dw ((27040/2) | 32768) ;13 Geoff Hi-Res	;
			.dw 1728	;14 Rainbow Grad 	;3008	;14 Rainbow Grad
			.dw ((23488/2) | 32768)	;15 PCE/HiChew
			.dw ((11328/2) | 32768)	;16 Boot Warning Screen

Pic_Bord_Col:		.dw 0,0,0,0,0,0,0,0,0,0,$008,$1ff,0,0,0,$1FF,0
Pic_Sprites_In:		.db 0,0,1,1,1,1,1,1	;0-7 (Display sprites on LOAD-IN of pic?
			.db 1,1,1,1,1,0,0,1,0	;8-16


Pic_BG_List:		.dw Sc1_CHR, Sc2_CHR, Sc3_CHR, Sc4_CHR, Sc5_CHR, Sc6_CHR, Sc7_CHR, Sc8_CHR, Sc9_CHR, Sc10_CHR
			.dw Sc11_CHR, Sc12_CHR, Sc13_CHR, Sc14_CHR, Sc15_CHR, Sc16_CHR, Sc17_CHR
Pic_BG_Bank_List:	.db BANK(Sc1_CHR), BANK(Sc2_CHR), BANK(Sc3_CHR), BANK(Sc4_CHR), BANK(Sc5_CHR), BANK(Sc6_CHR)
			.db BANK(Sc7_CHR), BANK(Sc8_CHR), BANK(Sc9_CHR), BANK(Sc10_CHR), BANK(Sc11_CHR), BANK(Sc12_CHR)
			.db BANK(Sc13_CHR), BANK(Sc14_CHR), BANK(Sc15_CHR), BANK(Sc16_CHR), BANK(Sc17_CHR)
Pic_SPR_List:		.dw Sc1_SPR, Sc2_SPR, Sc3_SPR, Sc4_SPR, Sc5_SPR, Sc6_SPR, Sc7_SPR, Sc8_SPR, Sc9_SPR, Sc10_SPR
			.dw Sc11_SPR, Sc12_SPR, Sc13_SPR, Sc14_SPR, Sc15_SPR, Sc16_SPR, Sc17_SPR
Pic_SPR_Bank_List:      .db BANK(Sc1_SPR), BANK(Sc2_SPR), BANK(Sc3_SPR), BANK(Sc4_SPR), BANK(Sc5_SPR), BANK(Sc6_SPR)
                        .db BANK(Sc7_SPR), BANK(Sc8_SPR), BANK(Sc9_SPR), BANK(Sc10_SPR), BANK(Sc11_SPR), BANK(Sc12_SPR)
			.db BANK(Sc13_SPR), BANK(Sc14_SPR), BANK(Sc15_SPR), BANK(Sc16_SPR), BANK(Sc17_SPR)
Pic_BAT_List:           .dw Sc1_BAT, Sc2_BAT, Sc3_BAT, Sc4_BAT, Sc5_BAT, Sc6_BAT, Sc7_BAT, Sc8_BAT, Sc9_BAT, Sc10_BAT
			.dw Sc11_BAT, Sc12_BAT, Sc13_BAT, Sc14_BAT, Sc15_BAT, Sc16_BAT, Sc17_BAT
Pic_BAT_Bank_List:      .db BANK(Sc1_BAT), BANK(Sc2_BAT), BANK(Sc3_BAT), BANK(Sc4_BAT), BANK(Sc5_BAT), BANK(Sc6_BAT)
                        .db BANK(Sc7_BAT), BANK(Sc8_BAT), BANK(Sc9_BAT), BANK(Sc10_BAT), BANK(Sc11_BAT), BANK(Sc12_BAT)
			.db BANK(Sc13_BAT), BANK(Sc14_BAT), BANK(Sc15_BAT), BANK(Sc16_BAT), BANK(Sc17_BAT)
Pic_BAT_VRAM:		.dw $0,$0,$0,$0,$0,$0,0,0,0,0,0,0,0,0,0,$C0,0


SubPic_BG_List:		.dw Test_Text6_Tiles,Test_Text5_Tiles,Test_Text4_Tiles,Test_Text2_Tiles
			.dw Test_Text3_Tiles,Test_Text1_Tiles
SubPic_BG_Bank_List:	.db BANK(Test_Text6_Tiles),BANK(Test_Text5_Tiles),BANK(Test_Text4_Tiles),BANK(Test_Text2_Tiles)
			.db BANK(Test_Text3_Tiles),BANK(Test_Text1_Tiles)
SubPic_BG_Size_List:	.dw 3584,1920,1888,1584,1712,2144

SubPic_BATA_List:	.dw Test_Text6_BATA,Test_Text5_BAT,Test_Text4_BAT,Test_Text2_BAT
			.dw Test_Text3_BAT,Test_Text1_BATA
SubPic_BATA_Bank_List:	.db BANK(Test_Text6_BATA),BANK(Test_Text5_BAT),BANK(Test_Text4_BAT),BANK(Test_Text2_BAT)
			.db BANK(Test_Text3_BAT),BANK(Test_Text1_BATA)
SubPic_BATA_VRAM:	.dw $01A0,$0320,$02A0,$0260,$0260,$01A0
SubPic_BATA_Size_List	.dw (506/2),(504/2),(316/2),(556/2),(358/2),(178/2)

SubPic_BATB_List:	.dw Test_Text6_BATB,-1,-1,-1,-1,Test_Text1_BATB
SubPic_BATB_Bank_List:	.db BANK(Test_Text6_BATB),-1,-1,-1,-1,BANK(Test_Text1_BATB)
SubPic_BATB_VRAM:	.dw $04A0,-1,-1,-1,-1,$04A0
SubPic_BATB_Size_List	.dw (370/2),-1,-1,-1,-1,(354/2)

			;PRESENTS, LOOK, ANY, YES!,KILL,CRY?
SubPic_Delay:		.db $A0,$50,$80,$50,$50,$FF

Load_SubPic_Tiles:
	ldx	<sub_picno
	lda	SubPic_BG_Bank_List,X
	tam	#2
	sta	<data_src_bank		;Bank # for source
	txa
	asl	a
	tax
	stw     #$0800,<vram_add	;This is fixed???
	lda	SubPic_BG_List,X
	sta	<data_src
	lda	SubPic_BG_List+1,X
	sta	<data_src+1
	lda	SubPic_BG_Size_List,X
	sta	<data_len
	lda	SubPic_BG_Size_List+1,X
	sta	<data_len+1

	lda	#TYP_DBL
	sta	<data_type	;VRAM data / expansion
	smb0	<fill_vram	;flag to fill VRAM ON!
	rts

Load_SubPic_BATA:
	ldx	<sub_picno
	lda	SubPic_BATA_Bank_List,X
	tam	#2
	sta	<data_src_bank		;Bank # for source
	txa
	asl	a
	tax
	lda	SubPic_BATA_VRAM,X
	sta	<vram_add
	lda	SubPic_BATA_VRAM+1,X
	sta	<vram_add+1
	lda	SubPic_BATA_List,X
	sta	<data_src
	lda	SubPic_BATA_List+1,X
	sta	<data_src+1
	lda	SubPic_BATA_Size_List,X
	sta	<data_len
	lda	SubPic_BATA_Size_List+1,X
	sta	<data_len+1

	lda	#TYP_BAT
	sta	<data_type	;VRAM data / expansion
	smb0	<fill_vram	;flag to fill VRAM ON!
	rts

Load_SubPic_BATB:
	ldx	<sub_picno
	lda	SubPic_BATB_Bank_List,X
	cmp	#$FF		;IF "-1", NO 2nd BAT.
	bne	.continue
	rts
.continue:
	tam	#2
	sta	<data_src_bank		;Bank # for source
	txa
	asl	a
	tax
	lda	SubPic_BATB_VRAM,X
	sta	<vram_add
	lda	SubPic_BATB_VRAM+1,X
	sta	<vram_add+1
	lda	SubPic_BATB_List,X
	sta	<data_src
	lda	SubPic_BATB_List+1,X
	sta	<data_src+1
	lda	SubPic_BATB_Size_List,X
	sta	<data_len
	lda	SubPic_BATB_Size_List+1,X
	sta	<data_len+1

	lda	#TYP_BAT
	sta	<data_type	;VRAM data / expansion
	smb0	<fill_vram	;flag to fill VRAM ON!
	rts



Assign_Pic_No:		;Lets me change the order of pictures easily
	pha
	phx
	ldx	<pic_enum
	lda	Pic_Order,X
	bpl	.no_reset
	stz     <pic_enum
	lda	Pic_Order
.no_reset:
	sta	<picno
	plx
	pla
	rts

Setup_VRAM_Fill:
	stwz	<fails
	lda	#TYP_FILL
	sta	<data_type	;VRAM data / expansion

	stwz	<vram_add	;VRAM write address
	stw	#$0080,<data_src	;DATA
	stw	#$0800,<data_len	;WORD Length of source data.
	smb0	<fill_vram	;flag to fill VRAM ON!
	rts

Setup_SPR_Clear:
	stwz	<fails
	lda	#TYP_FILL
	sta	<data_type	;VRAM data / expansion

	stw     #SPRIT_VRAM,<vram_add	;This is fixed???
	stw	#($8000-SPRIT_VRAM),<data_len
	stwz	<data_src	;DATA
	smb0	<fill_vram	;flag to fill VRAM ON!
	rts

Setup_BAT_Write:
	stwz	<fails
	lda	#TYP_BAT
	sta	<data_type	;VRAM data / expansion

	ldx	<picno
	lda     Pic_BAT_Bank_List,X
	tam	#2
	sta	<data_src_bank		;Bank # for source
	txa
	asl	a
	tax
	lda     Pic_BAT_VRAM,X
	sta     <vram_add
	lda     Pic_BAT_VRAM+1,X
	sta     <vram_add+1
	lda     Pic_BAT_List,X
	sta     <data_src
	lda     Pic_BAT_List+1,X
	sta     <data_src+1
	stw	#(1920/2),<data_len	;#$4000,<data_len	;WORD Length of source data.
	smb0	<fill_vram	;flag to fill VRAM ON!
	rts

Setup_Vram_Write:
	stwz	<fails

	ldx	<picno
	lda     Pic_BG_Bank_List,X
	tam	#2
	sta	<data_src_bank		;Bank # for source
	txa
	asl	a
	tax
	stw     #$0800,<vram_add	;This is fixed???
	lda     Pic_BG_List,X
	sta     <data_src
	lda     Pic_BG_List+1,X
	sta     <data_src+1
	lda     Pic_BG_Size_List,X
	sta     <data_len
	lda     Pic_BG_Size_List+1,X	;If high bit is SET = Not Doubled!
	bpl	.normal_double_write
;-----
	and	#$7F			;Clear high bit
	sta     <data_len+1
	lda	#TYP_NORM		;really Zero
	bra	.write_type
.normal_double_write:
	sta     <data_len+1
	lda	#TYP_DBL
.write_type:
	sta	<data_type	;VRAM data / expansion
;-------
	smb0	<fill_vram	;flag to fill VRAM ON!

	rts


Setup_SPR_Write:

	stwz	<fails
	lda	#TYP_DITH	;Double & Dither Sprite Bits
	sta	<data_type	;VRAM data

;	stw	#SPRIT_VRAM,<vram_add	;VRAM write address
;	stw	#((SpriteGfx & $1FFF)|$4000),<data_src	;source from ROM (always $4000-$5FFF)
;	lda	#BANK(SpriteGfx)	;#$10	;samples!
;	tam	#2
;	sta	<data_src_bank		;Bank # for source

	ldx	<picno
	lda     Pic_SPR_Bank_List,X
	tam	#2
	sta	<data_src_bank		;Bank # for source
	txa
	asl	a
	tax
	stw     #SPRIT_VRAM,<vram_add	;This is fixed???
	lda     Pic_SPR_List,X
	sta     <data_src
	lda     Pic_SPR_List+1,X
	sta     <data_src+1
	stw	#($8000-SPRIT_VRAM),<data_len	;#$4000,<data_len	;WORD Length of source data.
	smb0	<fill_vram	;flag to fill VRAM ON!

	rts


Squirt_VRAM:	;Write to VRAM when we have time
	lda     <data_type	;What kind of data to write?
	bne	.not_norm_vram
	jmp	Normal_Squirt
.not_norm_vram:
	cmp	#TYP_DBL
	bne	.not_double
	jmp	Double_Squirt	;sounds gross, I know
.not_double:
	cmp	#TYP_DITH
	bne	.not_dither
	jmp	Dither_Squirt
.not_dither:
	cmp	#TYP_BAT
	bne	.not_bat
	jmp	BAT_Squirt
	rts
.not_bat:
	cmp	#TYP_FILL
	bne	.not_fill
	jmp	Fill_Squirt
.not_fill:
	rts


; 0 - Normal VRAM Upload
Normal_Squirt:
	lda     [data_src]
	tax			;low data byte in X
	incw	<data_src       ;Increment ONCE here, once later.
	lda     [data_src]
	tay			;high data byte in Y
	bra     _post_dith
; 2 - Dithered -------------------
Dither_Squirt:
	jsr	__double_dith
__double_dith:
	lda     [data_src]
	jsr	Unpack_Bits	;Unpack A reg to X and Y reg
	jsr	Dither_Spr	;dithers the graphics going out
	bra     _post_dith
; 1 - Doubled ------------------
Double_Squirt:
	jsr	__double_wide
__double_wide:
	lda     [data_src]
	jsr	Unpack_Bits	;Unpack A reg to X and Y reg
_post_dith:
.start:
	lda     <vram_add
	rmb0	<interrupted	;turn off "interrupted"
	st0	#0		;VRAM Write reg
	sta	video_data	;Set address first
	lda	<vram_add+1
	sta	video_data+1
	;choose one or the other!
	bbs0    <interrupted,.start
;;	bbs0    <interrupted,.failed_this_time
	st0	#2
	stx     video_data  	;Write WORD into VRAM!
	sty	video_data+1
	;choose one or the other!
	bbs0    <interrupted,.start
;;	bbs0    <interrupted,.failed_this_time
	;VRAM write succeeded, maybe?
	incw    <data_src	;Go 1 byte ahead
	incw	<vram_add       ;Go 1 VRAM address ahead
	decw	<data_len       ;Decrement our WORD length
	ora	<data_len	;Test Hi byte *OR* Low byte
	beq	.finished_all_writing
	lda	<data_src+1
	cmp	#$60		;did we go off into $6000---?
	bne     .finished_this_write
	lda	#$40
	sta     <data_src+1	;point back to $4000
	tma	#2
	inc	a
	tam	#2		;go to next bank
.finished_this_write:
	rts
.finished_all_writing:
        rmb0	<fill_vram	;Turn off our flag!
	rts
.failed_this_time:	;VRAM write failed once... :-(
	incw	<fails
	rts


Dither_Spr:
;AND Dither mask on sprites in VRAM: 5555AAAA5555AAAA......
	bbs0	<data_src,.even_dith	;this will be ODD or EVEN
	txa
	and	#$55
	tax
	tya
	and	#$55
	tay
	rts
.even_dith:
	txa
	and	#$AA
	tax
	tya
	and	#$AA
	tay
	rts



BAT_Squirt:
	lda     [data_src]
	tax			;low data byte in X
	incw	<data_src       ;Increment ONCE here, once later.
	lda     [data_src]
	tay			;high data byte in Y
.start:
	lda     <vram_add
	rmb0	<interrupted	;turn off "interrupted"
	st0	#0		;VRAM Write reg
	sta	video_data	;Set address first
	lda	<vram_add+1
	sta	video_data+1
	bbs0    <interrupted,.start
;;	bbs0    <interrupted,.failed_this_time
	st0	#2
	stx     video_data  	;Write WORD into VRAM!
	sty	video_data+1
	;choose one or the other!
	bbs0    <interrupted,.start
;;	bbs0    <interrupted,.failed_this_time
	;VRAM write succeeded, maybe?
	incw    <data_src	;Go 1 byte ahead
	incw	<vram_add       ;Go 1 VRAM address ahead
	decw	<data_len       ;Decrement our WORD length
	ora	<data_len	;Test Hi byte *OR* Low byte
	beq	.finished_all_writing
	lda	<vram_add
	and	#$1F		;has it done 32 chars just now?
	bne	.no_adj_vram    ;if 1..31, not yet.
	addw	#32,<vram_add
.no_adj_vram:
	lda	<data_src+1
	cmp	#$60		;did we go off into $6000---?
	bne     .finished_this_write
	lda	#$40
	sta     <data_src+1	;point back to $4000
	tma	#2
	inc	a
	tam	#2		;go to next bank
.finished_this_write:
	rts
.finished_all_writing:
        rmb0	<fill_vram	;Turn off our flag!
	rts
.failed_this_time:	;VRAM write failed once... :-(
	incw	<fails
	rts



Fill_Squirt:
	ldx	<data_src
	ldy	<data_src+1
.start:
	lda     <vram_add
	rmb0	<interrupted	;turn off "interrupted"
	st0	#0		;VRAM Write reg
	sta	video_data	;Set address first
	lda	<vram_add+1
	sta	video_data+1
	st0	#2
	stx     video_data  	;Write WORD into VRAM!
	sty	video_data+1
	stx     video_data  	;Write WORD into VRAM!
	sty	video_data+1
	stx     video_data  	;Write WORD into VRAM!
	sty	video_data+1
	stx     video_data  	;Write WORD into VRAM!
	sty	video_data+1
	;choose one or the other!
	bbs0    <interrupted,.start
;;	bbs0    <interrupted,.failed_this_time
	;VRAM write succeeded, maybe?
;	incw	<vram_add       ;Go 1 VRAM address ahead
;	decw	<data_len       ;Decrement our WORD length
	addw	#4,<vram_add
	subw	#4,<data_len
	ora	<data_len	;Test Hi byte *OR* Low byte
	beq	.finished_all_writing
	rts
.finished_all_writing:
        rmb0	<fill_vram	;Turn off our flag!
	rts
.failed_this_time:	;VRAM write failed once... :-(
	incw	<fails
	rts



;*******************************************************************************
pick_pic_pal:
	tma	#2		;Get BANK
	pha
	lda	#PALS_BANK
	tam	#2

	lda	<picno		;Picture number 0,1,2...
	asl	a               ;make high byte of Palette Source!
;---------
	pha
	tax
	lda	Pic_Bord_Col,X	;Choose colour for border
	sta	<BorderCol
        lda	Pic_Bord_Col+1,X
	sta	<BorderCol+1
	pla
;---------
	ora	#$40
	sta	TIA_DEST
	stwz	color_reg	;point to BG Palette 0
	jsr	TIA_RAM
	pla
	tam	#2
	rts

TIA_Pal:
	tia	$4000,color_data,$0200	;256 palette entries
	rts




SPR_ON_OR_OFF:		;Some pics shouldn't have sprites on when loading in.
	ldx	<picno
	lda	Pic_Sprites_In,X
	bne	.no_change
	BG_ON	;SPRITES OFF!
.no_change:
	rts





Scroll_Warping:		;Test if we need to scroll the screen
	bbr7	<warp_on,.no_warp
	;-warping is ON, check mosaic or scroll
	bbs0    <warp_on,.scroll_left ;or right, whatever
	lda	<mstr_scan_size
	cmp	#$FF
	beq	.finish_mosaic
	inc	<mstr_scan_size
	lda	<mstr_scan_size
	lsr	a
	lsr	a
	inc	a
	sta	<scan_size
	rts
.finish_mosaic:
	stz     <warp_on
	rts
.scroll_left:

.no_warp:
	rts



Colour_Cycling:
	;set cycle speed here:
	lda	<nmi_count
	and	#$03
	bne     .no_cycl
	bbs0	<fade_on,.do_fade
	bbs0	<cycle_on,.do_cycle
.no_cycl:
	rts
;----------------------------
.do_fade:
	lda     <cyclepos
	cmp	#2
	bne	.cont_fade
;fade finished here
        rmb0	<fade_on
	rts
.cont_fade:
	lda     <cyclepos
	dec	a
	dec	a
	sta	<cyclepos
	bra	pick_sprite_pal
;------------------------------------
.do_cycle:
	lda     <cyclepos
	inc	a
	inc	a
	cmp	#32	;has it gone past my palette?
	bne	.no_cycl_overflow
	lda	#2
.no_cycl_overflow:
	sta	<cyclepos

;	rts


pick_sprite_pal:
	lda	<paletteno
	asl	a	;x2
	asl	a
	asl	a
	asl	a       ;x16
	sta	<_si
	stz	<_si+1
	aslw	<_si	;x32
	addw    #SprPal,<_si
	stw	#$100,color_reg	;point to Sprite Palette 0

;;	ldy	#1          	;This does palette entry #0 (Border colour)
;;	lda	[_si]
	lda	<BorderCol
	sta	color_data
;;	lda	[_si],Y
	lda	<BorderCol+1
	sta	color_data+1
;----------------------
	ldx	#15
;	cly
	ldy	<cyclepos
.pal_loop:
	lda	[_si],Y
	sta	color_data
	iny
	lda	[_si],Y
	sta	color_data+1
	iny

	bbr0	<cycle_on,.no_cycle_check
.do_cycle:
	cpy	#32	;has it gone past my palette?
	bne	.no_cycle_overflow
	ldy	#2
.no_cycle_overflow:
.no_cycle_check:
	dex
	bne	.pal_loop
	rts


Shake_Screen:	;Set scroll to weird values
	lda	<nmi_count
	and	#$0F
	tax
	lda	XShake_Tbl,X
	sta	<scroll_x
	lda	YShake_Tbl,X
	sta	<scroll_y
	rts

XShake_Tbl:
	.db 10,5,15,3,18,6,14,9,11,7,13,4,17,5,15,7
YShake_Tbl:
	.db 5,0,3,8,2,6,4,6,5,4,7,3,9,4,6,4
AcidPal: .incpal "GFX\acidpal.pcx",0,2	;32 colours of gradients


Weird_Pals:		;Flash the screen (and hidden palettes) a weird colour
	lda	<nmi_count
	lsr	a
	lsr	a
	and	#$3E
	tax
	stwz	color_reg	;point to BG Palette 0
	lda	AcidPal,X
	sta	<BorderCol
	sta	color_data
	lda	AcidPal+1,X
	tax
	stx	<BorderCol+1
	stx	color_data+1

	stw	#14*16,color_reg	;point to BG Palette E
	lda	<BorderCol

	ldy	#$B
.morecolours:
	sta	color_data
	stx	color_data+1
	dey
	bne	.morecolours

	stwz    color_data	;Black for "????".  Yeah, a hack
	sta	color_data
	stx	color_data+1
	sta	color_data
	stx	color_data+1
;	rts	;drop down?



Change_Border_Colour:
	stw	#$100,color_reg	;point to Sprite Palette 0
	lda	<BorderCol
	sta	color_data
	lda	<BorderCol+1
	sta	color_data+1
	rts


Text_Delay_Table:
	IF (FASTFAST=1)
	.dw	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5
	ELSE
	.dw	80	;<sigh>
	.dw	200
	.dw	150	;Here I sit...
	.dw	150
	.dw	160	;forgotten
	.dw	140
	.dw	130	;My glory days long behind me
	.dw	100
	.dw	50	;Heh
	.dw	40
	.dw	140	;Some glory days...
	.dw	100
	.dw	180	;Near the end...
	.dw	300
	.dw	160	;Maybe I could...
	.dw	50
	.dw	50	;???
	.dw	80
	.dw     80	;HIGH Chew?
	.dw	50
	.dw     80	;Chew Chew?
	.dw	50
	ENDIF


Set_Text_Anim_Palette:	;Sets an indexed palette entry BLACK or WHITE in BG Pal $0E
	stw	#$E2,color_reg	;point to BG Palette $E
	bbs0	<textstepno,.pal1_white
	lda     <textstepno
	cmp	#16	;at "????" stage
	beq     .pal1_white	;hide voice "BAR"
	stwz	color_data	;BLACK
	bra	.index_to_pal
.pal1_white:
	stw	#$1FF,color_data
.index_to_pal:
	lda     <textstepno
	lsr	a
	add	#$E3		;point to palette entry
	sta     color_reg
	stz	color_reg+1
	bbs0	<textstepno,.pal2_white
	stwz	color_data	;BLACK
	bra	.index_done
.pal2_white:
	stw	#$1FF,color_data
.index_done:


	rts
;*************************************************


Unpack_Bits:	;Unpacks A reg to X and Y reg by doubling each bit
	ldx	#4
.bitloopL:
	lsr	a
	bcs	.bitset
	lsr	<_al	;bit's not set anyway
	lsr	<_al
	bra	.donebitL
.bitset:
	ror	<_al
	sec
	ror	<_al
.donebitL:
	dex
	bne	.bitloopL
;---
	ldx	#4
.bitloopH:
	lsr	a
	bcs	.bitsetH
	lsr	<_ah	;bit's not set anyway
	lsr	<_ah
	bra	.donebitH
.bitsetH:
	ror	<_ah
	sec
	ror	<_ah
.donebitH:
	dex
	bne	.bitloopH

	ldx	<_al		;low data byte in X
	ldy	<_ah		;high data byte in Y
	rts

;********************************************************


	IF (1=0)
Scan_Size_Tbl:	;A logarithmic scale for scanline sizes
 .db 1,1,1,1,1,1,1
 .db 2,2,2,2,2,2,2
 .db 3,3,3,3,3,3,3
 .db 4,4,4,4,4,4
 .db 5,5,5,5,5,5
 .db 6,6,6,6,6
 .db 7,7,7,7,7
 .db 8,8,8,8
 .db 9,9,9
 .db 10,10
 .db 11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26
 .db 27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44
 .db 45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64
	ENDIF





BAT_3264:			;Set virtual width to 32, height to 64
	st0	#9
	st1	#%01000000
	st2	#0
	rts

BAT_6432:			;Set virtual width to 64, height to 32
	st0	#9
	st1	#%00010000
	st2	#0
	rts

yres_224:
	st0 #$0C
	stw #$1702,video_data
	st0 #$0D
	stw #$00DF,video_data
	rts

yres_240:
;;	st0	#$0C  	"Default"
;;	st1     #$02
;;	st2	#$0D
;;	st0	#$0D
;;	st1	#$EF
;;	st2	#$00

	st0	#$0C
	st1     #$01
	st2	#$0D
	st0	#$0D
	st1	#$F2
	st2	#$00
	rts

yres_up:
	st0	#$0C
	st1     #$01
	st2	#$0C
	rts

xres_320:
;;	vreg	#$0A                  "Default"
;;	stw	#$0303,video_data
;;	vreg	#$0B
;;	stw	#$062B,video_data

	vreg	#$0A
	stw	#$091B,video_data	;'1B' makes it stable at any width.
	vreg	#$0B
	stw	#$061F,video_data
	lda	#$1F                    ;Above register controls width of screen!
	sta	<scr_width
	lda	#%00000001	;Artifacts OFF!
	sta	$0400
	rts

Change_Width:
	vreg	#$0B
	lda     <scr_width
	sta	video_data
	lda	#$06
        sta	video_data+1
	st0	#1	;MEMORY READ REG!
	rts

xres_256:
	st0	#$0A
	st1	#$02
	st2	#$02
	st0	#$0B
	st1	#$1F
	st2	#$04
	lda	#%00000100	;or #%00000000 for chroma fix OFF
	sta	$0400
	sta	<VCE_copy
	rts

Set_BG_SPR:
	lda	<bgspron
	st0  #5
	sta	video_data
	st2   #$00
	rts

TextPal:
	.incbin "GFX\texttest_PAL.bin"
