NextPic_MAC	.macro
	.dw dstep_00,dstep_01,dstep_02,dstep_04,dstep_05
	.dw dstep_next_pic_sprites,dstep_next_pic_after_sprites
		.endm

;TEXTPIC_MAC	.macro		;FUCKIN' BUGGY MACROS!!!
;	;Show some text after the pic!
;	.dw dstep_testtext1A, dstep_testtext1B
;	.dw dstep_testtext1C, dstep_testtext1D
;	.dw dstep_testtext1E, dstep_testtext1F
;		.endm

Step_Tbl: 	.dw dstep_dummy

	;Load in my Boot Screen!
	.dw dstep_boot_screen_load, dstep_Tiles_BG,dstep_boot_screen_show
	.dw dstep_boot_screen_end

		;First, load in PCE, HiChew, HiChew Sprite
	.dw dstep_clr, dstep_1st_sprites
	.dw dstep_bat1, dstep_bat2, dstep_hic_sprite, dstep_posn_hic_spr
	.dw dstep_Tiles_BG,dstep_pce_on
		;Do palette-changing animation until Hi-Chew drops
	.dw dstep_text_engine1
		;Scroll sprite on-screen
	.dw dstep_move_hic_spr
		;A couple more palette-changing animation
	.dw dstep_text_engine1
	.dw dstep_show_2ndBG
	.dw dstep_show_1stBG
		;One more palette-changing animation
	.dw dstep_text_engine1
	.dw dstep_return_sprite0
;;;	.dw dstep_rainbow_pal
	.dw dstep_question_marks
	.dw dstep_shake_screen	;or something
	.dw dstep_next_pic_after_sprites



	;Spec Rainbow
	.dw dstep_00,dstep_01,dstep_1st_Tiles_BG		;Load all in
	.dw dstep_load_1st_extra_tiles
	.dw dstep_rainbow_pal
	.dw dstep_narrow_screen, dstep_widen_screen, dstep_flash_screen

	.dw dstep_05
	.dw dstep_next_pic_sprites,dstep_next_pic_after_sprites
Step_Tbl_Loop_Point:

;;;;	.dw dstep_rainbow_pal

	NextPic_MAC	;Pic CMC

	;"PRESENTS..."
	.dw dstep_testtext1A, dstep_testtext1B
	.dw dstep_testtext1C, dstep_testtext1D
	.dw dstep_testtext1E, dstep_testtext1F

	;Pic MAND
	.dw dstep_00,dstep_01,dstep_02,dstep_04_TITLE,dstep_05
	.dw dstep_next_pic_sprites,dstep_next_pic_after_sprites

	NextPic_MAC	;Tut
	NextPic_MAC	;shack

	;"LOOK FOR IT"
	.dw dstep_testtext1A, dstep_testtext1B
	.dw dstep_testtext1C, dstep_testtext1D
	.dw dstep_testtext1E, dstep_testtext1F

	NextPic_MAC	;road
	NextPic_MAC	;Sunny Field

	;"ANY COLOUR FPS YOU LIKE"
	.dw dstep_testtext1A, dstep_testtext1B
	.dw dstep_testtext1C, dstep_testtext1D
	.dw dstep_testtext1E, dstep_testtext1F

	NextPic_MAC	;Skyscraper
	NextPic_MAC	;shrine
	NextPic_MAC	;Blossoms
	NextPic_MAC	;Mazda

	;"YES! OLD IS BEAUTIFUL"
	.dw dstep_testtext1A, dstep_testtext1B
	.dw dstep_testtext1C, dstep_testtext1D
	.dw dstep_testtext1E, dstep_testtext1F


	NextPic_MAC	;Pic 11 - Boombox
	NextPic_MAC	;Pic 12 - Solar system
	NextPic_MAC	;Pic 13, Yoshiko

	;"SHE'D KILL ME"
	.dw dstep_testtext1A, dstep_testtext1B
	.dw dstep_testtext1C, dstep_testtext1D
	.dw dstep_testtext1E, dstep_testtext1F


	;Geoff Rainbow
	.dw dstep_00,dstep_01,dstep_02,dstep_rainbow_pal,dstep_04_geoff
	.dw dstep_05, dstep_post_geoff	;.dw dstep_screen_end
	.dw dstep_wait_warped


        ;"WHY CRY?"
	.dw dstep_testtext1A, dstep_testtext1B
	.dw dstep_testtext1C, dstep_testtext1D
	.dw dstep_testtext1E, dstep_testtext1F


	.dw dstep_Loop_1st_Pic
	.dw dstep_End

;=============================================
dstep_dummy:	;do nothing at this step!
	rts
;=============================================
;=============================================
dstep_boot_screen_load:
	map	BootPal
	stwz	color_reg
	tia	BootPal,color_data,32
	jsr	Setup_BAT_Write

;	rmb7	<samp_on	;NOW start the sample engine
;	smb0	<samp_on        ;HSync player active


	inc	<stepno
	rts
;=============================================
;=============================================
dstep_boot_screen_show:
	jsr	Change_Border_Colour
	BG_ON
	IF (FASTFAST=1)
	stw	#$40,<picdelay
	ELSE
	stw	#$200,<picdelay
	ENDIF
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_boot_screen_end:
	lda	<picdelay
	ora	<picdelay+1
	beq	.next_bg_step
	decw    <picdelay
	rts
.next_bg_step:
	SCREEN_OFF
	inc	<pic_enum
	jsr	Assign_Pic_No
	inc	<stepno
	rts
;=============================================



;=============================================
dstep_clr:	;do nothing at this step!
	jsr	Setup_VRAM_Fill
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_1st_sprites:
	jsr	Setup_SPR_Clear
	inc	<stepno
	rts
;=============================================

;=============================================
dstep_bat1:
	jsr	pick_pic_pal	;Palette comes from regular pic stuff
	jsr	Setup_BAT_Write
	stw	#((768+832)/2),<data_len	;HACK IN Length of small BAT.
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_bat2:
	lda	#TYP_BAT
	sta	<data_type	;VRAM data / expansion
	stw     #$00E0,<vram_add	;2nd screen
	lda     #BANK(Sc16_BAT2)
	tam	#2
	sta	<data_src_bank		;Bank # for source
	stw	#Sc16_BAT2,<data_src
	stw	#(1504/2),<data_len	;HACK IN Length of small BAT.
	smb0	<fill_vram	;flag to fill VRAM ON!
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_hic_sprite:
	lda     #BANK(Sc16_SPR)
	tam	#2
	sta	<data_src_bank		;Bank # for source
	stw     #SPRIT_VRAM,<vram_add	;This is fixed???
	stw     #Sc16_SPR,<data_src
	stw     #$100,<data_len
	lda	#TYP_NORM		;really Zero
	sta	<data_type	;VRAM data / expansion
	smb0	<fill_vram	;flag to fill VRAM ON!

	inc	<stepno
	rts
;=============================================
dstep_posn_hic_spr:
	lda     #14
	sta	<paletteno
	jsr	pick_sprite_pal
	cla
	sta	<HiC_Pos
	jsr	Position_Sprite_0

	inc	<stepno
	rts
;=============================================
dstep_pce_on:
	stz	<textstepno	;At step 0
	IF (FASTFAST=1)
	stw	#$20,<picdelay
	ELSE
	stw	#$100,<picdelay	;Initial delay
	ENDIF
	jsr	Change_Border_Colour
	SCREEN_ON
	inc	<stepno
	rts
;=============================================

;=============================================
dstep_text_engine1:		;This will reveal, and hide, text on-screen.
	lda	<picdelay
	ora	<picdelay+1
	beq	.next_text_step
;;;	bbs0	<pause,.no_timing
	decw    <picdelay
.no_timing:
	rts
.next_text_step:
	lda     <textstepno
	cmp	#15		;Break right after "playstation" comment
	beq	.done_all_steps
	cmp	#18		;Break after ??? comment
	beq     .done_all_steps
	cmp	#20		;Break after High Chew comment
	beq     .done_all_steps
			;Not done all steps, change the palette then RELOAD DELAY
	asl	a
	tax
	lda     Text_Delay_Table,X
	sta	<picdelay
	lda     Text_Delay_Table+1,X
	sta	<picdelay+1
	jsr	Set_Text_Anim_Palette	;Show text on-screen
	inc	<textstepno
	rts

.done_all_steps:
	inc	<stepno
	rts
;=============================================


;=============================================

dstep_move_hic_spr:
	lda	<HiC_Pos
	cmp	#$E0		;Have we scrolled the sprite down yet?
	beq	.sprite_done
	add	#$10
	sta     <HiC_Pos
	jsr	Position_Sprite_0
	rts
.sprite_done:
	jsr	Set_Text_Anim_Palette
	inc	<textstepno	;move to next "reaction" shot
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_show_2ndBG:
	stw	#$100,<picdelay	;Initial delay
	stw	#$100,<scroll_x
	BG_ON
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_show_1stBG:
	lda	<picdelay
	ora	<picdelay+1
	beq	.next_bg_step
;;;	bbs0	<pause,.no_timing
	decw    <picdelay
	rts
.next_bg_step:
	jsr	Set_Text_Anim_Palette
	inc	<textstepno	;move to next "reaction" shot
	stw	#$100,<picdelay	;Initial delay
	stwz	<scroll_x
	
	SCREEN_ON
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_return_sprite0:
;;	lda     #14
;;	sta	<paletteno
;;	jsr	pick_sprite_pal
;	lda	#16	;????? marks
	lda	#20	;<chew chew>
	sta	<textstepno
	jsr	Set_Text_Anim_Palette	;Show text on-screen
	lda	#$40
	sta	<HiC_Pos
	jsr	Position_Sprite_0
	BG_ON				;Hide sprites, but load them!
	inc	<pic_enum
	jsr	Assign_Pic_No
	jsr	Setup_SPR_Write		;Draw in Sprites while we MOSAIC away!
	addw	#$800,<vram_add		;Hack in a smaller CHR size of our rainbow sprite!
	subw	#$800,<data_len

;;	rmb7	<samp_on	;NOW start the sample engine
;;	smb0	<samp_on        ;HSync player active


	inc	<stepno
	rts
;=============================================
dstep_question_marks:
	lda	#21	;Clear chew chew
	sta	<textstepno
	jsr	Set_Text_Anim_Palette	;Show text on-screen
	lda	#16	;????? marks
	sta	<textstepno
	jsr	Set_Text_Anim_Palette	;Show text on-screen
;;;;;	BG_ON				;Hide sprites, but load them!

	;clear some sprite VRAM.
	stw	#SPRIT_VRAM,<vram_add	;VRAM write address
	stwz	<data_src		;ZERO OUT DATA
	stw	#$0800,<data_len	;WORD Length of source data.
	lda	#TYP_FILL
	sta	<data_type	;VRAM data / expansion
	smb0	<fill_vram	;flag to fill VRAM ON!



	rmb7	<samp_on	;NOW start the sample engine
	smb0	<samp_on        ;HSync player active

	stw	#$160,<picdelay
	inc	<stepno
	rts
;=============================================
dstep_shake_screen:
	lda	<picdelay
	ora	<picdelay+1
	bne     .do_shakey
	stwz	<BorderCol
;	jsr	Change_Border_Colour
	inc	<stepno
	rts
.do_shakey:
	decw    <picdelay
	;shake screen, do palette stuff maybe...
	jsr	Shake_Screen
	jsr	Weird_Pals
	rts
;=============================================


;=============================================
dstep_1st_BAT1:
	jsr	pick_pic_pal
	jsr	Setup_BAT_Write
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_1st_Tiles_BG:
	jsr	Setup_Vram_Write
	;But customize starting address...
	addw     #$0500,<vram_add

	inc	<stepno
	rts
;=============================================

;=============================================
dstep_load_1st_extra_tiles:
	lda     #BANK(Colour_Limit_Tiles)
	tam	#2
	sta	<data_src_bank		;Bank # for source
	stw     #$0800,<vram_add	;This is fixed???
	stw     #Colour_Limit_Tiles,<data_src
	stw	#(2560/2),<data_len
	lda	#TYP_NORM		;really Zero
	sta	<data_type	;VRAM data
	smb0	<fill_vram	;flag to fill VRAM ON!
	inc	<stepno
	rts
;=============================================

;=============================================
dstep_narrow_screen:
	stwz	<scroll_x
	stwz	<scroll_y

	jsr	Change_Border_Colour
	lda	#2	;#$00
	sta	<scr_width
	jsr	Change_Width
	BG_ON
	stwz	<picdelay
	inc	<stepno
	rts
;=============================================
dstep_widen_screen:
	lda	<picdelay
	ora	<picdelay+1
	beq	.next_width
	decw    <picdelay
	rts
.next_width:
	lda     <scr_width
	cmp	#$1D
	beq     .widen_once
	cmp	#$1F
	bne     .not_wide_yet
;	SCREEN_ON
	stw	#$ef,<picdelay
	stz	<pause		;Ensure no pausing prior to this...
	inc	<stepno
	rts
.not_wide_yet:
	inc     <scr_width
.widen_once:
	inc     <scr_width
	inc     <scr_width
	jsr	Change_Width
	stw	#21,<picdelay
	rts
;=============================================
dstep_flash_screen:
	lda	<picdelay
	ora	<picdelay+1
	beq	.full_sprites
	decw    <picdelay
	lda     <picdelay
	cmp	#$2F
	bcc	.flash_screen
	rts
.flash_screen:
	bbs1	<nmi_count,.show_bg
	SCREEN_ON
	rts
.show_bg:
	BG_ON
	rts
.full_sprites:
	SCREEN_ON
	stw	#PIC_DELAY,<picdelay
;---- upload the 2nd BAT piece
	lda	#TYP_BAT
	sta	<data_type	;VRAM data / expansion
	lda     #BANK(Colour_Limit_BAT2)
	tam	#2
	sta	<data_src_bank		;Bank # for source
	stw	#$0080,<vram_add
	stw	#Colour_Limit_BAT2,<data_src
	stw	#(128/2),<data_len
	smb0	<fill_vram	;flag to fill VRAM ON!

	inc	<stepno
	rts
;=============================================
dstep_00:
	jsr	pick_sprite_pal
	inc	<stepno
	rts
;=============================================
dstep_01:
	jsr	pick_pic_pal
	jsr	Setup_BAT_Write
	inc	<stepno
	rts
;=============================================
dstep_02:
dstep_Tiles_BG:
	jsr	Setup_Vram_Write
	inc	<stepno
	rts
;=============================================
;;dstep_03:
;	BG_ON
	;was 	jsr	Setup_SPR_Write
;;	inc	<stepno
;;	rts
;=============================================
dstep_04:			;SHOW PICTURE HERE
	jsr	Change_Border_Colour
	SCREEN_ON
	stw	#PIC_DELAY,<picdelay
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_04_TITLE:			;SHOW PICTURE HERE
	jsr	Change_Border_Colour
	SCREEN_ON
	stw	#TITLEPIC_DELAY,<picdelay
	inc	<stepno
	rts
;=============================================
dstep_05:			;WAIT BEFORE WARPING OUT
	lda	<picdelay
	ora	<picdelay+1
	beq	.start_fadeout
	bbs0	<pause,.no_timing
	decw    <picdelay
.no_timing:
	rts
.start_fadeout:
	;last step, so....
	stwz	<BorderCol	;Border Colour BLACK immediately
	smb0	<fade_on        ;Fade out ON
	rmb0	<cycle_on       ;Cycling OFF
	stz	<paletteno	;Greyscale again
	lda	#$22		;Fully faded in
	sta	<cyclepos		;(pointer to palette entry)
	smb7	<warp_on	;Turn warping ON
	rmb0	<warp_on	;Make it MOSAIC

	inc	<stepno
	rts
;=============================================

;=============================================
dstep_screen_end:
	lda	<picdelay
	ora	<picdelay+1
	beq	.next_bg_step
	decw    <picdelay
	rts
.next_bg_step:
	SCREEN_OFF
	rmb0	<cycle_on       ;Cycling OFF
	stz	<paletteno	;Greyscale again
	lda	#$22		;Fully faded in
	sta	<cyclepos		;(pointer to palette entry)
	inc	<stepno
	rts
;=============================================



;=============================================
dstep_next_pic_sprites:
	bbs0    <fade_on,.not_sprite_in	;Don't load in sprites yet.
;;;;;;;;	inc	<picno	;Next Picture
	rmb0	<cycle_on       ;Cycling starts OFF
	stz	<paletteno	;Greyscale again
	lda	#$22		;Fully faded in
	sta	<cyclepos		;(pointer to palette entry)

	inc	<pic_enum
	jsr	Assign_Pic_No
	jsr	SPR_ON_OR_OFF
	jsr	Setup_SPR_Write		;Draw in Sprites while we MOSAIC away!
	inc	<stepno
.not_sprite_in:
	rts
;=============================================
dstep_next_pic_after_sprites:
	SCREEN_OFF
	rmb7	<warp_on	;WARPING OFF
	lda	#1
	sta	<mstr_scan_size
	sta	<scan_size
	lda	#$22		;Fully faded in
	sta	<cyclepos		;(pointer to palette entry)
	inc	<stepno
	rts
;=============================================



;=============================================
dstep_next_pic:
	rmb0    <fade_on	;Fading OFF
	rmb7	<warp_on	;WARPING OFF
	lda	#1
	sta	<mstr_scan_size
	sta	<scan_size
	lda	#$22		;Fully faded in
	sta	<cyclepos		;(pointer to palette entry)
;;;	inc	<picno	;Next Picture
	inc	<pic_enum
	jsr	Assign_Pic_No
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_04_geoff:			;SHOW PICTURE HERE
	jsr	Change_Border_Colour
	SCREEN_ON
	stw	#GEOFF_PIC_DELAY,<picdelay
	inc	<stepno
	rts
;=============================================




;=============================================
dstep_testtext1A:
	SCREEN_OFF
	rmb0    <fade_on	;Fading OFF
	rmb7	<warp_on	;WARPING OFF
	lda	#1
	sta	<mstr_scan_size
	sta	<scan_size
;-----------
	lda	#TYP_FILL
	sta	<data_type	;VRAM data / expansion
	stwz	<vram_add	;VRAM write address
	stw	#$0080,<data_src	;DATA
	stw	#$0800,<data_len	;WORD Length of source data.
	smb0	<fill_vram	;flag to fill VRAM ON!

	inc	<stepno
	rts
;=============================================
;=============================================
dstep_testtext1B:
	jsr	Load_SubPic_Tiles
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_testtext1C:
	jsr	Load_SubPic_BATA
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_testtext1D:
	jsr	Load_SubPic_BATB
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_testtext1E:
	stwz	color_reg	;point to BG Palette 0
	tia	TextPal,color_data,18
	stw	#$100,<scroll_x
	
	ldx	<sub_picno
	lda	SubPic_Delay,X
	sta	<picdelay	;Initial delay
	stz	<picdelay+1
	BG_ON
	inc	<stepno
	rts
;=============================================
;=============================================
dstep_testtext1F:
	lda	<picdelay
	ora	<picdelay+1
	beq	.next_bg_step
	decw    <picdelay
	rts
.next_bg_step:
	SCREEN_OFF
	inc	<sub_picno	;GO TO NEXT SUB PICTURE!
	stwz	<scroll_x
	rmb0	<cycle_on       ;Cycling OFF
	stz	<paletteno	;Greyscale again
	lda	#$22		;Fully faded in
	sta	<cyclepos		;(pointer to palette entry)
	inc	<stepno
	rts
;=============================================
dstep_post_geoff:
	BG_ON
	inc	<stepno
	rts
;=============================================
dstep_wait_warped:
	lda	<mstr_scan_size
	cmp	#$70
	bne	.notyet
	inc	<stepno
.notyet:
	rts


;=============================================

;=============================================
dstep_rainbow_pal:
	lda	#2
	sta	<cyclepos		;(pointer to palette entry)
	lda	#4		;This sets the SPRite overlay PAL!
	sta	<paletteno
	smb0	<cycle_on       ;Turn Cycling ON
	inc	<stepno
	rts
;=============================================


;=============================================
dstep_Loop_1st_Pic:
	bbr0    <fade_on,.loopback
	rts
.loopback:
	SCREEN_OFF
	rmb0    <fade_on	;Fading OFF
	rmb7	<warp_on	;WARPING OFF
	lda	#1
	sta	<mstr_scan_size
	sta	<scan_size
	rmb0	<cycle_on       ;Cycling starts OFF
	stz	<paletteno	;Greyscale again
	lda	#$22		;Fully faded in
	sta	<cyclepos		;(pointer to palette entry)
	stz	<sub_picno
;;;	stz	<picno		
	lda	#3		;First pic again
	sta	<pic_enum
	jsr	Assign_Pic_No
	jsr	Setup_SPR_Write		;Draw in Sprites while we MOSAIC away!
	lda	#(Step_Tbl_Loop_Point-Step_Tbl)/2	;#2
	sta	<stepno         ;BACK!
	rts

;=============================================



;=============================================
dstep_End:
	stz	<stepno
	rts
;=============================================
