.MEM	8
.INDEX	8
.OPT	ON
.ORG	$A000

FREEZE_PLAY = $00F0
SOUND_OFF	= $00F1

SPR_RAM = $0200
;
	rti
	jmp	NMI_SUB
	jmp	Reset_SUB
;
SONG_NO	.db	$00
CONTROLLER1 .db	$00	;7-> A,B,SL,ST,U,D,L,R <-0
CONTROLLER2 .db	$00
CONT1LAST	.db	$80		;Reading of the last controller
CONT2LAST	.db	$00
LAST_BUTTON .db	$01
CONT1STROBE	.db	$00
CONT2STROBE	.db	$00
NMI_PASS	.db	$00		;Has NMI passed?
VBCOUNT	.db	$00
UPDATEDELAY .db	$02
;
NMI_SUB
	php
	pha
	txa
	pha
	tya
	pha
;	jsr	VU_METER
	jsr	$E9C8		;Copy SPR-RAM
	lda	FREEZE_PLAY
	bne	NoPlayMusic
	lda	#%10010111
	sta	$2001
	jsr	$D32A		;PLAY Address
	lda	#%00010110
	sta	$2001
NoPlayMusic
	lda	SOUND_OFF
	beq	NoTurnOffSound
	lda	#$00
	sta	$4015
NoTurnOffSound
	jsr	Controller_Magic
	jsr	BTN_READ
	lda	#$01
	sta	NMI_PASS
	INC	VBCOUNT
	jsr	FDS_HOOK
	pla
	tay
	pla
	tax
	pla
	plp
	rti

VU_METER
	ldx	#$03
	ldy	#$00
-	lda	$4040,Y
	asl
	sec
	sbc	#$40
	sta	SPR_RAM,X
	inx
	inx
	inx
	inx
	iny
	cpy	#$40
	bne	-
	rts
;
FDS_HOOK
	pha
	lda	#$C0
	sta	$0100
	lda	#$80
	sta	$0101
	lda	#$35
	sta	$0102
	lda	#$53
	sta	$0103
	pla
	rts
;

Reset_SUB
	cld
	sei
	lda	#$00
	sta	$2000
	sta	$2001

-	lda	$2002		;Wait for VBlank
	bpl	-

	ldx	#$FF
	txs
	ldy	#$07
	sty	$0001
	ldy	#$00
	sty	$0000
	lda	#$00

-	sta	($0000),y	;Clear all RAM
	dey
	bne	-
	dec	$0001
	bpl	-

	lda	#$10
	sta	$2006		;SPR-CHR
	lda	#$00
	sta	$2006

	ldx	#$00
-	sta	$2007		;Clear 2 tiles
	inx
	cpx	#$20
	bne	-

	lda	#$10
	sta	$2006
	sta	$2006
	lda	#$18
	sta	$2007		;Set tile 1 to 2 lines.
	sta	$2007

	ldx	#$00
	stx	NMI_PASS
-
	lda	SPR_BASE,X
	sta	SPR_RAM,X
	inx
	bne	-

	lda	SONG_NO
	jsr	$D030		;INIT Address

	jsr	FDS_HOOK
	lda	#%10001000		;NMI,Sprite CHR
	sta	$2000
	lda	#%00010110		;Sprites on, no clipping.
	sta	$2001
Done_Loop
	lda	NMI_PASS
	beq	Done_Loop
	lda	#$00
	sta	NMI_PASS
	lda	VBCOUNT
	cmp	UPDATEDELAY
	bne	Done_Loop
	lda	#$00
	sta	VBCOUNT
	jsr	VU_METER
	jmp	Done_Loop
;
BTN_READ

	lda	CONT1STROBE
	and	#%00100000		;Check for "select"
	beq	Not_Select
	lda	FREEZE_PLAY
	eor	#$01			
	sta	FREEZE_PLAY		;Suspend PLAY address
Not_Select
	lda	CONT1STROBE
	and	#%00010000
	beq	Not_Start
	lda	SOUND_OFF
	eor	#$01
	sta	SOUND_OFF		;Turn off NES/FC sound channels
	cmp	#$00
	bne	Not_Start
	lda	#%00001111
	sta	$4015
Not_Start
	lda	CONT1STROBE
	and	#%00001000
	beq	Not_Up
	dec	UPDATEDELAY		;Change delay time to update sprites...
	bne	Not_Up		;Check if at 0
	lda	#$01
	sta	UPDATEDELAY
	lda	#$00
	sta	VBCOUNT
Not_Up
	lda	CONT1STROBE
	and	#%00000100
	beq	Not_Down
	inc	UPDATEDELAY
	lda	#$00
	sta	VBCOUNT
Not_Down
	lda	CONT1STROBE
	and	#$80
	beq	NO_ACTION
	inc	SONG_NO
	lda	SONG_NO
	and	#$07
	sta	SONG_NO
	lda	#$00
	sta	CONT1STROBE
	lda	#$80
	sta	CONT1LAST
	sta	CONTROLLER1
	jmp	Reset_SUB		;INFO: indirect jump
;
NO_ACTION
	rts

Controller_Magic
	lda	CONTROLLER1
	sta	CONT1LAST
	lda	CONTROLLER2
	sta	CONT2LAST
	ldx	#$01
	jsr	$E9EE		;Read Controller -> $F5,$F6
	lda	$F5
	sta	CONTROLLER1
	lda	$F6
	sta	CONTROLLER2
;----------------------
	lda	CONT1LAST	;Read old controller status
	eor	#$FF		;Inverse (a mask!)
	and	CONTROLLER1
	sta	CONT1STROBE	;Check strobe of controllers!
	lda	CONT2LAST
	eor	#$FF
	and	CONTROLLER2
	sta	CONT2STROBE
	rts
;
SPR_BASE .INCBIN "sprram.bin"

.PAD $D000